# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IZHuRRPI
                                 A QGIS plugin
 Identification des Zones Humides Ralentissant les Ruisselements et Prévenant
 Inondations
                              -------------------
        begin                : 2019-09-01
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import os.path, unicodedata



class boite :

   def boite_rouge_simple(y, z):
      y.setStyleSheet('QLineEdit {border: 2px solid #E54719}')
      z.setStyleSheet('QLabel {color : #E54719}')

   def boite_verte_simple(y, z):
      y.setStyleSheet('QLineEdit {border: 2px solid #B3C21A}')
      z.setStyleSheet('QLabel {color : #B3C21A}')

   def boite_rouge(x, y, z):
      x.setStyleSheet('QToolButton {background-color: #E54719; border: 2px solid #E54719 ; color : white}')
      y.setStyleSheet('QLineEdit {border: 2px solid #E54719}')
      z.setStyleSheet('QLabel {color : #E54719}')

   def boite_verte(x, y, z):
      x.setStyleSheet('QToolButton {background-color: #B3C21A ; border: 2px solid #B3C21A ; color : white}')
      y.setStyleSheet('QLineEdit {border: 2px solid #B3C21A}')
      z.setStyleSheet('QLabel {color : #B3C21A}')

   def message(self,texte,info):
      """

      :rtype: object
      """
      msg1 = QMessageBox()
      msg1.setIcon(QMessageBox.Warning)
      msg1.setText(texte)
      msg1.setInformativeText(info)
      msg1.setWindowTitle(u"Avertissement")
      return msg1

   def message_chemin(self):
      msg1 = QMessageBox()
      msg1.setIcon(QMessageBox.Warning)
      msg1.setText(u"Le chemin comporte des espaces ou des caractères spéciaux")
      msg1.setInformativeText(u"Modifiez le chemin avant de relancer")
      msg1.setWindowTitle(u"Avertissement")
      return msg1

   def controle_chemin(self,str_lineedit,toolbutton,lineedit,label):

      envoyeur = self.sender()
      lien = envoyeur.text()
      lien = unicode(lien)
      lien = unicodedata.normalize('NFKD', lien).encode('ascii', 'ignore')


      if envoyeur.objectName() == str_lineedit:
         if envoyeur.text() == "":
            boite.boite_rouge(toolbutton, lineedit, label)
         if envoyeur.text() != "":
            boite.boite_verte(toolbutton, lineedit, label)

            #### Verification de l'existence d'accent ou d'espace dans le lien ####
            if os.path.exists(lien) == False or envoyeur.text().find(' ') != -1:
               boite.boite_rouge(toolbutton, lineedit, label)
               boite.message_chemin(self).exec_()
               lineedit.clear()