/*
Objet :
	Import des 2 données annexes provenant de fichiers spécifiques
!!!!!!!!!!!!!!!!!!! Important !!!!!!!!!!!!!!!!!!!!!
	NECESSITE DE PARAMETRER LES CHEMINS ET LES NOMS DES TABLES ANNEXES
Auteur : 
	CEREMA "PCI Foncier et Stratégies Foncières"
	Direction Territoriale Nord-Picardie pour le compte EPF Nord Pas de Calais / DGALN
	Antoine Herman
	Jérôme Douché
	
Droits :	
	Ce script est fourni sous licence Creative Commons 3.0 CC-BY-SA
	http://creativecommons.org/licenses/by-sa/3.0/fr/
	
Version 1.2 - Mars 2015 :
		- précision de l'encodage
		- modification pour l'import de données locales sur un serveur distant
			(NOTA : pour un import en local depuis l'interface SQL de pgAdmin,
			il est nécessaire de retirer l'antislash devant les requetes COPY ... FROM ... )
*/

SET client_encoding = 'UTF8';

----------------------------------------
-- Création des tables annexes temporaires
----------------------------------------

-- CREATION DE TABLES TEMPORAIRES

	--> table ann_cgi
DROP TABLE IF EXISTS dvf.tmp_ann_cgi;
CREATE TABLE dvf.tmp_ann_cgi
(
	article_cgi character varying(20),
	lib_article_cgi character varying(254),
	CONSTRAINT tmp_ann_cgi_unique PRIMARY KEY (article_cgi)
);

	--> table tmp_ann_nature_culture
DROP TABLE IF EXISTS dvf.tmp_ann_nature_culture;
CREATE TABLE dvf.tmp_ann_nature_culture
(
	nature_culture character varying(2),
	lib_nature_culture character varying(254),
	CONSTRAINT tmp_ann_nature_culture_pkey PRIMARY KEY (nature_culture)	
);

	--> table tmp_ann_nature_culture_speciale
DROP TABLE IF EXISTS dvf.tmp_ann_nature_culture_speciale;
CREATE TABLE dvf.tmp_ann_nature_culture_speciale
(
	nature_culture_speciale character varying(5),
	lib_nature_culture_speciale character varying(254),
	CONSTRAINT tmp_nature_culture_speciale_pkey PRIMARY KEY (nature_culture_speciale)
);


-- IMPORT DES DONNEES DANS LES TABLES TEMPORAIRES

-- *********************************************
-- !!!!!!!!!!!!!!!!!!! ATTENTION : 3 CHEMINS A PARAMETRER !!!!!!!!!!!!!!!!!!! 
-- *********************************************

-- NOTA : pour un import en local depuis l'interface SQL de pgAdmin,
--			il est nécessaire de retirer l'antislash devant les requetes COPY ... FROM ... 

	--> table ann_nature_culture
\COPY dvf.tmp_ann_nature_culture FROM 'D:/Postgres_donnees/dvf/documents/natcult.csv' WITH DELIMITER AS '|'  ENCODING 'UTF-8';

	--> table ann_nature_culture_speciale
\COPY dvf.tmp_ann_nature_culture_speciale FROM 'D:/Postgres_donnees/dvf/documents/natcultspe.csv' WITH DELIMITER AS '|' ENCODING 'UTF-8' ;

	--> table ann_cgi
\COPY dvf.tmp_ann_cgi FROM 'D:/Postgres_donnees/dvf/documents/artcgil135b.csv' WITH DELIMITER AS '|' ENCODING 'UTF-8' ;

-- *********************************************
-- !!!!!!!!!!!!!!!!!!! FIN DE LA SECTION A PARAMETRER !!!!!!!!!!!!!!!!!!! 
-- *********************************************


-- MAJ DES TABLES ANNEXES
INSERT INTO dvf.ann_cgi 
(
	article_cgi,lib_article_cgi
)
(
	SELECT t1.article_cgi, t1.lib_article_cgi 
	FROM dvf.tmp_ann_cgi t1
	LEFT JOIN dvf.ann_cgi t2 
	ON t1.article_cgi=t2.article_cgi
	WHERE t2.article_cgi IS NULL
);

INSERT INTO dvf.ann_nature_culture 
(
	nature_culture,lib_nature_culture
)
(
	SELECT t1.nature_culture, t1.lib_nature_culture
	FROM dvf.tmp_ann_nature_culture t1
	LEFT JOIN dvf.ann_nature_culture t2 
	ON t1.nature_culture=t2.nature_culture
	WHERE t2.nature_culture IS NULL
);

INSERT INTO dvf.ann_nature_culture_speciale 
(
	nature_culture_speciale,lib_nature_culture_speciale
)
(
	SELECT t1.nature_culture_speciale, t1.lib_nature_culture_speciale
	FROM dvf.tmp_ann_nature_culture_speciale t1
	LEFT JOIN dvf.ann_nature_culture_speciale t2 
	ON t1.nature_culture_speciale=t2.nature_culture_speciale
	WHERE t2.nature_culture_speciale IS NULL
);


-- SUPPRESSION DES TABLES TEMPORAIRES
DROP TABLE IF EXISTS dvf.tmp_ann_cgi;
DROP TABLE IF EXISTS dvf.tmp_ann_nature_culture;
DROP TABLE IF EXISTS dvf.tmp_ann_nature_culture_speciale;






