/*
Objet :
	Import des données DVF dans le modèle défini par l'ADEF
!!!!!!!!!!!!!!!!!!! Important !!!!!!!!!!!!!!!!!!!!!
	NECESSITE DE PARAMETRER LE CHEMIN ET LE NOM DU FICHIER DVF A IMPORTER
Auteur : 
	CEREMA "PCI Foncier et Stratégies Foncières"
	Direction Territoriale Nord-Picardie pour le compte EPF Nord Pas de Calais / DGALN
	Antoine Herman
	Jérôme Douché
	
Droits :	
	Ce script est fourni sous licence Creative Commons 3.0 CC-BY-SA
	http://creativecommons.org/licenses/by-sa/3.0/fr/
	
Version 1.2 - Mars 2015 :
		- précision de l'encodage
		- modification pour l'import de données locales sur un serveur distant
			(NOTA : pour un import en local depuis l'interface SQL de pgAdmin,
			il est nécessaire de retirer l'antislash devant la requete COPY ... FROM ... )
		- ajout d'une fonction PGCD, utilisée pour éliminer les informations redondantes concernant les sufs et évaluer leur surface.
		- modification de la requête de mise à jour de la table 'ann_nature_mutation'
		- correction 'code_departement' et 'code_commune' pour prise en compte des départements d'outre-mer.
		- variable 'identifiant_local' de la table 'import.dvf' : varchar(7) >> varchar(10)
*/

SET client_encoding = 'UTF8';


-- ******************************
-- CREATION FONCTION PGCD
-- ******************************


CREATE OR REPLACE FUNCTION dvf.pgcd(valeurs integer[])
  RETURNS integer AS
$BODY$
/*
  Retourne le Plus Grand Commun Diviseur de l'ensemble des valeurs du tableau d'entier.
  Si le tableau ne contient qu'un seul entier, Retourne sa valeur absolue.
 
  Exemple : SELECT pgcd(ARRAY[14,28,49,70]);
  7
 */
DECLARE
	v integer[];
	reste integer;
	a integer;
	b integer;
	gcd integer;
BEGIN
	v := valeurs;
	gcd := 0;
	IF array_length(v,1) > 1 THEN		
		a := v[1];	
		FOR i IN 2..array_upper(v,1)
		LOOP 		
			b:=v[i];
			IF b<>0 THEN 
				LOOP
					reste:=a%b;
					a:=b;
					b:=reste;
					EXIT WHEN reste=0;
				END LOOP;
				
				IF abs(a) < gcd OR gcd = 0 THEN 
					gcd := abs(a);
					a := gcd;
				END IF;
				EXIT WHEN gcd=1;
			ELSE
				gcd=0;
				EXIT;
			END IF;	
		END LOOP;
	ELSE
		gcd = abs(v[1]);
	END IF;
		RETURN gcd;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE STRICT
  COST 100;


-- ******************************
-- SUPPRESSION PREALABLE SI NECESSAIRE
-- ******************************
DROP SCHEMA IF EXISTS import CASCADE ;
CREATE SCHEMA import;

-- ******************************
-- CREATION DE LA TABLE VIDE POUR IMPORT DES DONNEES
-- ******************************

CREATE TABLE import.dvf
(
	code_service_ch character varying(7),
	reference_document character varying(10),
	"1_articles_cgi" character varying(20),
	"2_articles_cgi" character varying(20),
	"3_articles_cgi" character varying(20),
	"4_articles_cgi" character varying(20),
	"5_articles_cgi" character varying(20),
	no_disposition integer,
	date_mutation date,
	nature_mutation character varying(34),
	valeur_fonciere character varying, 	-- PASSE EN NUMERIC ENSUITE APRES AVOIR REMPLACE LES VIRGULES PAR DES POINTS
	no_voie integer,	
	b_t_q character varying(1),		
	type_de_voie character varying(4),	
	code_voie character varying(4),		
	voie character varying(254),		
	code_postal character varying(5),	
	commune character varying(254),	
	code_departement character varying(3),	-- COMPLETE ENSUITE PAR DES "0" SI NECESSAIRE
	code_commune character varying(3),		-- COMPLETE ENSUITE PAR DES "0" SI NECESSAIRE
	prefixe_de_section character varying(3),	-- COMPLETE ENSUITE PAR DES "0" SI NECESSAIRE
	section character varying(2),			-- COMPLETE ENSUITE PAR DES "0" SI NECESSAIRE
	no_plan character varying(4),			-- COMPLETE ENSUITE PAR DES "0" SI NECESSAIRE
	no_volume character varying(7),		
	"1er_lot" character varying(7),
	surface_carrez_du_1er_lot character varying, 	-- PASSE EN NUMERIC ENSUITE APRES AVOIR REMPLACE LES VIRGULES PAR DES POINTS
	"2eme_lot" character varying(7),
	surface_carrez_du_2eme_lot character varying, 	-- PASSE EN NUMERIC ENSUITE APRES AVOIR REMPLACE LES VIRGULES PAR DES POINTS
	"3eme_lot" character varying(7),
	surface_carrez_du_3eme_lot character varying, 	-- PASSE EN NUMERIC ENSUITE APRES AVOIR REMPLACE LES VIRGULES PAR DES POINTS
	"4eme_lot" character varying(7),
	surface_carrez_du_4eme_lot character varying, 	-- PASSE EN NUMERIC ENSUITE APRES AVOIR REMPLACE LES VIRGULES PAR DES POINTS
	"5eme_lot" character varying(7),
	surface_carrez_du_5eme_lot character varying, 	-- PASSE EN NUMERIC ENSUITE APRES AVOIR REMPLACE LES VIRGULES PAR DES POINTS
	nombre_de_lots integer,
	code_type_local integer,			
	type_local character varying(254),
	identifiant_local character varying(10),
	surface_reelle_bati integer,
	nombre_pieces_principales integer,
	nature_culture character varying(2),			
	nature_culture_speciale character varying(5),	
	surface_terrain integer
);

-- ******************************
-- IMPORT DES DONNEES
-- ******************************

-- *********************************************
-- !!!!!!!!!!!!!!!!!!! ATTENTION : CHEMIN ET NOM DU FICHIER A PARAMETRER !!!!!!!!!!!!!!!!!!! 
-- !!!!!!!!!!!!!!!!!!! ATTENTION : IMPORTER QU'UN SEUL FICHIER A LA FOIS !!!!!!!!!!!!!!!!!!! 
-- *********************************************

-- NOTA : pour un import en local depuis l'interface SQL de pgAdmin,
--			il est nécessaire de retirer l'antislash devant la requete COPY ... FROM ... 

\COPY import.dvf FROM 'D:\Postgres_donnees\dvf\ValeursFoncieres-ZF590001-1114-2013.txt' WITH DELIMITER AS '|' CSV HEADER ENCODING 'UTF-8' FORCE NOT NULL code_departement,code_commune ,prefixe_de_section ,section,no_plan;

-- *********************************************
-- !!!!!!!!!!!!!!!!!!! FIN DU PARAMETRAGE !!!!!!!!!!!!!!!!!!! 
-- *********************************************





-- ******************************
-- CREATION D'UNE TABLE DVF1
-- ******************************
CREATE TABLE import.dvf1 AS 
(
	SELECT 
		code_service_ch, reference_document, 
		"1_articles_cgi", "2_articles_cgi", "3_articles_cgi", "4_articles_cgi", "5_articles_cgi", no_disposition, 
		date_mutation, nature_mutation, 

		(replace(valeur_fonciere, ',', '.'))::numeric AS valeur_fonciere, 

				no_voie, b_t_q, 
		type_de_voie, code_voie, voie, code_postal, commune, 
		CASE WHEN code_departement NOT LIKE '97_' THEN lpad(code_departement, 2, '0') ELSE code_departement END AS code_departement,
		CASE WHEN code_departement NOT LIKE '97_' THEN lpad(code_commune, 3, '0') ELSE lpad(code_commune, 2, '0') END AS code_commune,
		lpad(prefixe_de_section, 3, '0') AS prefixe_de_section,
		lpad(section, 2, '0') AS section,
		lpad(no_plan, 4, '0') AS no_plan,
		no_volume, 
		"1er_lot", (replace(surface_carrez_du_1er_lot, ',', '.'))::numeric AS surface_carrez_du_1er_lot, 
		"2eme_lot", (replace(surface_carrez_du_2eme_lot, ',', '.'))::numeric AS surface_carrez_du_2eme_lot, 
		"3eme_lot", (replace(surface_carrez_du_3eme_lot, ',', '.'))::numeric AS surface_carrez_du_3eme_lot, 
		"4eme_lot", (replace(surface_carrez_du_4eme_lot, ',', '.'))::numeric AS surface_carrez_du_4eme_lot, 
		"5eme_lot", (replace(surface_carrez_du_5eme_lot, ',', '.'))::numeric AS surface_carrez_du_5eme_lot, 
		nombre_de_lots, code_type_local, 
		type_local, identifiant_local, surface_reelle_bati, nombre_pieces_principales, 
		nature_culture, nature_culture_speciale, surface_terrain,

		CASE WHEN code_departement NOT LIKE '97_' THEN lpad(code_departement, 2, '0') ELSE code_departement END||
			CASE WHEN code_departement NOT LIKE '97_' THEN lpad(code_commune, 3, '0') ELSE lpad(code_commune, 2, '0') END||
			lpad(prefixe_de_section, 3, '0')||lpad(section, 2, '0')||lpad(no_plan, 4, '0') 
		AS idpar,

		CASE WHEN no_voie IS NULL THEN '' ELSE no_voie::varchar END || '$' ||
			CASE WHEN b_t_q IS NULL THEN '' ELSE b_t_q END || '$' ||
			CASE WHEN code_voie IS NULL THEN '' ELSE code_voie END || '$' ||
			CASE WHEN type_de_voie IS NULL THEN '' ELSE type_de_voie END || '$' ||
			CASE WHEN voie IS NULL THEN '' ELSE voie END || '$' ||
			CASE WHEN code_postal IS NULL THEN '' ELSE code_postal END || '$' ||
			CASE WHEN commune IS NULL THEN '' ELSE commune END 
		AS idadr_tmp,
		
		CASE WHEN nature_culture IS NULL THEN '' ELSE nature_culture::varchar END || '$' ||
			CASE WHEN nature_culture_speciale IS NULL THEN '' ELSE nature_culture_speciale::varchar END || '$' ||
			CASE WHEN surface_terrain IS NULL THEN '' ELSE surface_terrain::varchar END
		AS idsuf_tmp
		
	FROM 
		import.dvf
);








-- ******************************
--MISE A JOUR DES TABLES ANNEXES DEPENDANT DE DVF ("ann_nature_mutation")
-- ******************************
/*

ancienne requête (version 0.1)

INSERT INTO dvf.ann_nature_mutation(lib_nature_mutation)
(
	SELECT nature_mutation 
	FROM import.dvf 
	WHERE 
		nature_mutation IS NOT NULL 
		AND nature_mutation NOT IN (SELECT nature_mutation FROM dvf.ann_nature_mutation) GROUP BY nature_mutation ORDER BY nature_mutation
); */

INSERT INTO dvf.ann_nature_mutation(lib_nature_mutation)
(
	SELECT t.nature_mutation 
	FROM import.dvf t
	LEFT JOIN dvf.ann_nature_mutation t1 ON t.nature_mutation = t1.lib_nature_mutation
	WHERE t1.id_nature_mutation IS NULL
	GROUP BY t.nature_mutation
);

-- ******************************
-- MAJ DES TABLES
-- ******************************
-----------------
-- id_mutation
-----------------
INSERT INTO dvf.mutation 
(
	code_service_ch, reference_document, date_mutation, id_nature_mutation
)
(
	SELECT t.code_service_ch, t.reference_document, t.date_mutation, t1.id_nature_mutation
	FROM import.dvf1 t
	LEFT JOIN dvf.ann_nature_mutation t1 ON t.nature_mutation=t1.lib_nature_mutation
	LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document 
	WHERE t2.id_mutation IS NULL
	GROUP BY t.code_service_ch, t.reference_document, t.date_mutation, t1.id_nature_mutation
	--ORDER BY t.code_service_ch, t.reference_document, t.date_mutation, t1.id_nature_mutation
);

-----------------
-- id_disposition
-----------------
INSERT INTO dvf.disposition 
(
	id_mutation, no_disposition, valeur_fonciere,nombre_de_lots
)
(
	SELECT tt.id_mutation, tt.no_disposition, tt.valeur_fonciere, array_agg(tt.nombre_de_lots) AS nombre_de_lots
	FROM
	(
		SELECT t2.id_mutation, t.no_disposition, t.valeur_fonciere, t.nombre_de_lots
		FROM import.dvf1 t
		LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document
		LEFT JOIN dvf.disposition t3 ON t2.id_mutation=t3.id_mutation AND t.no_disposition=t3.no_disposition
		WHERE id_disposition IS NULL
		GROUP BY t2.id_mutation, t.no_disposition,t.valeur_fonciere, t.nombre_de_lots
		--ORDER BY t2.id_mutation, t.no_disposition,t.valeur_fonciere
	) tt
	GROUP BY tt.id_mutation, tt.no_disposition, tt.valeur_fonciere
);

-----------------
--id_parcelle
-----------------
INSERT INTO dvf.parcelle 
(
	idpar, code_departement, code_commune, prefixe_de_section, section, no_plan
)
(
	SELECT 
		t.idpar,
		t.code_departement,
		t.code_commune,
		t.prefixe_de_section,
		t.section,
		t.no_plan
	FROM import.dvf1 t
	LEFT JOIN dvf.parcelle t4 ON t.idpar=t4.idpar
	WHERE t4.id_parcelle IS NULL
	GROUP BY t.idpar, t.code_departement, t.code_commune, t.prefixe_de_section, t.section, t.no_plan
	--ORDER BY t.idpar, t.code_departement, t.code_commune, t.prefixe_de_section, t.section, t.no_plan
);

-----------------
--disposition_parcelle
-----------------
INSERT INTO dvf.disposition_parcelle 
(
	id_disposition, id_parcelle--, nombre_de_lots
)
(
	SELECT t3.id_disposition, t4.id_parcelle--, max(t.nombre_de_lots)
	FROM import.dvf1 t
	LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document 
	LEFT JOIN dvf.disposition t3 ON t2.id_mutation=t3.id_mutation AND t.no_disposition=t3.no_disposition
	LEFT JOIN dvf.parcelle t4 ON t.idpar=t4.idpar
	LEFT JOIN dvf.disposition_parcelle t5 ON t3.id_disposition=t5.id_disposition AND t4.id_parcelle=t5.id_parcelle
	WHERE t5.id_dispoparc IS NULL
	GROUP BY t3.id_disposition, t4.id_parcelle
	--ORDER BY t3.id_disposition, t4.id_parcelle
);

-----------------
-- Création d'une table temporaire pour finir de créer les tables restantes DVF2
-----------------

CREATE TABLE import.dvf2 AS
(
	SELECT 
		t5.id_dispoparc,
		t3.id_disposition, 
		t4.id_parcelle,
		-- pour table "volume"
		no_volume, 
		-- pour table "lot"
		"1er_lot", surface_carrez_du_1er_lot, "2eme_lot", surface_carrez_du_2eme_lot, 
		"3eme_lot", surface_carrez_du_3eme_lot, "4eme_lot", surface_carrez_du_4eme_lot, 
		"5eme_lot", surface_carrez_du_5eme_lot, 
		-- pour table "local"
		code_type_local, type_local, identifiant_local, surface_reelle_bati, nombre_pieces_principales,
		-- pour table "suf" 
		nature_culture, nature_culture_speciale, surface_terrain,
		-- pour table "adresse"
		no_voie, b_t_q, type_de_voie, code_voie, voie, code_postal, commune,
		-- pour tous
		idadr_tmp, idsuf_tmp
	FROM import.dvf1 t
	LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document 
	LEFT JOIN dvf.disposition t3 ON t2.id_mutation=t3.id_mutation AND t.no_disposition=t3.no_disposition
	LEFT JOIN dvf.parcelle t4 ON t.idpar=t4.idpar
	LEFT JOIN dvf.disposition_parcelle t5 ON t3.id_disposition=t5.id_disposition AND t4.id_parcelle=t5.id_parcelle
);
CREATE INDEX dvf2_id_dispoparc_btree_idx ON import.dvf2 USING BTREE(id_dispoparc);

----------------
-- adresse
-----------------
INSERT INTO dvf.adresse 
(
	no_voie, b_t_q, code_voie, type_de_voie, voie, code_postal, commune, idadr_tmp
)
(
	SELECT t.no_voie, t.b_t_q, t.code_voie, t.type_de_voie, t.voie, t.code_postal, t.commune, t.idadr_tmp
	FROM import.dvf1 t
	LEFT JOIN dvf.adresse t6 ON t.idadr_tmp=t6.idadr_tmp
	WHERE t6.id_adresse IS NULL
	GROUP BY t.no_voie, t.b_t_q, t.code_voie, t.type_de_voie, t.voie, t.code_postal, t.commune, t.idadr_tmp
	ORDER BY t.no_voie, t.b_t_q, t.code_voie, t.type_de_voie, t.voie, t.code_postal, t.commune, t.idadr_tmp
);

-----------------
-- local
-----------------
INSERT INTO dvf.local 
(
	id_dispoparc, identifiant_local, code_type_local, nombre_pieces_principales, surface_reelle_bati
)
(
	SELECT t.id_dispoparc, t.identifiant_local, t.code_type_local, t.nombre_pieces_principales, t.surface_reelle_bati
	FROM import.dvf2 t
	LEFT JOIN dvf.local t7 ON t.id_dispoparc=t7.id_dispoparc AND t.identifiant_local=t7.identifiant_local
	WHERE 
		t7.id_local IS NULL
		AND t.identifiant_local IS NOT NULL
	GROUP BY t.id_dispoparc, t.identifiant_local, t.code_type_local, t.nombre_pieces_principales, t.surface_reelle_bati
	ORDER BY t.id_dispoparc, t.identifiant_local, t.code_type_local, t.nombre_pieces_principales, t.surface_reelle_bati
);

-----------------
-- volume
-----------------
INSERT INTO dvf.volume 
(
	id_dispoparc, no_volume
)
(
	SELECT t.id_dispoparc, t.no_volume
	FROM import.dvf2 t
	LEFT JOIN dvf.volume t8 ON t.id_dispoparc=t8.id_dispoparc AND t.no_volume=t8.no_volume
	WHERE 
		t8.id_volume IS NULL
		AND t.no_volume IS NOT NULL
	GROUP BY t.id_dispoparc, t.no_volume
	ORDER BY t.id_dispoparc, t.no_volume
);

-----------------
-- suf 
-----------------
--> Creation d'une table temporaire avec le nombre de sufs identiques non nulles
----DROP TABLE IF EXISTS import.tmp_suf;
CREATE TABLE import.tmp_suf AS
(
	SELECT
		id_dispoparc, count(*) as nb_suf_idt, surface_terrain, nature_culture, nature_culture_speciale, idsuf_tmp
	FROM 
		import.dvf2 t1
	WHERE
		nature_culture IS NOT NULL
	GROUP BY 
		id_dispoparc, surface_terrain, nature_culture, nature_culture_speciale, idsuf_tmp
);
CREATE INDEX tmp_suf_id_dispoparc_btree_idx ON import.tmp_suf USING BTREE(id_dispoparc);

INSERT INTO dvf.suf 
(
	id_dispoparc, nb_suf_idt, surface_terrain, nature_culture, nature_culture_speciale, idsuf_tmp
)
(
	SELECT
		t1.id_dispoparc, t1.nb_suf_idt/t2.pgcd_nb_suf_idt AS nb_suf_idt, t1.surface_terrain*t1.nb_suf_idt/t2.pgcd_nb_suf_idt AS surface_terrain, t1.nature_culture, t1.nature_culture_speciale, t1.idsuf_tmp
	FROM 
		import.tmp_suf t1
	LEFT JOIN
		(SELECT id_dispoparc, dvf.pgcd(array_agg(nb_suf_idt)::integer[]) AS pgcd_nb_suf_idt FROM import.tmp_suf GROUP BY id_dispoparc) t2
	ON
		t1.id_dispoparc=t2.id_dispoparc
	LEFT JOIN
		dvf.suf t3
	ON 
		t1.id_dispoparc=t3.id_dispoparc
	WHERE
		t3.id_dispoparc IS NULL
);


----DROP TABLE IF EXISTS import.tmp_suf;

-----------------
-- id_lot (id_suf, id_local et id_volume enlevés)
-----------------
INSERT INTO dvf.lot
(
	id_dispoparc, id_local, id_suf, id_volume, no_lot, surface_carrez
)
(
	SELECT t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, 1 as no_lot, surface_carrez_du_1er_lot
	FROM import.dvf2 t1
	LEFT JOIN dvf.lot t2 ON t1.id_dispoparc=t2.id_dispoparc AND t2.no_lot=1
	LEFT JOIN dvf.local t3 ON t1.id_dispoparc=t3.id_dispoparc AND t1.identifiant_local=t3.identifiant_local
	LEFT JOIN dvf.suf t4 ON t1.id_dispoparc=t4.id_dispoparc AND t1.idsuf_tmp=t4.idsuf_tmp
	LEFT JOIN dvf.volume t5 ON t1.id_dispoparc=t5.id_dispoparc AND t1.no_volume=t5.no_volume
	WHERE 
		t1."1er_lot" IS NOT NULL 
		AND t2.id_lot IS NULL
	GROUP BY t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, surface_carrez_du_1er_lot
	
	UNION
	
	SELECT t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, 2 as no_lot, surface_carrez_du_2eme_lot
	FROM import.dvf2 t1
	LEFT JOIN dvf.lot t2 ON t1.id_dispoparc=t2.id_dispoparc AND t2.no_lot=2
	LEFT JOIN dvf.local t3 ON t1.id_dispoparc=t3.id_dispoparc AND t1.identifiant_local=t3.identifiant_local
	LEFT JOIN dvf.suf t4 ON t1.id_dispoparc=t4.id_dispoparc AND t1.idsuf_tmp=t4.idsuf_tmp
	LEFT JOIN dvf.volume t5 ON t1.id_dispoparc=t5.id_dispoparc AND t1.no_volume=t5.no_volume
	WHERE 
		t1."2eme_lot" IS NOT NULL 
		AND t2.id_lot IS NULL
	GROUP BY t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, surface_carrez_du_2eme_lot
	
	UNION
	
	SELECT t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, 3 as no_lot, surface_carrez_du_3eme_lot
	FROM import.dvf2 t1
	LEFT JOIN dvf.lot t2 ON t1.id_dispoparc=t2.id_dispoparc AND t2.no_lot=3
	LEFT JOIN dvf.local t3 ON t1.id_dispoparc=t3.id_dispoparc AND t1.identifiant_local=t3.identifiant_local
	LEFT JOIN dvf.suf t4 ON t1.id_dispoparc=t4.id_dispoparc AND t1.idsuf_tmp=t4.idsuf_tmp
	LEFT JOIN dvf.volume t5 ON t1.id_dispoparc=t5.id_dispoparc AND t1.no_volume=t5.no_volume
	WHERE 
		t1."3eme_lot" IS NOT NULL 
		AND t2.id_lot IS NULL
	GROUP BY t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, surface_carrez_du_3eme_lot
	
	UNION
	
	SELECT t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, 4 as no_lot, surface_carrez_du_4eme_lot
	FROM import.dvf2 t1
	LEFT JOIN dvf.lot t2 ON t1.id_dispoparc=t2.id_dispoparc AND t2.no_lot=4
	LEFT JOIN dvf.local t3 ON t1.id_dispoparc=t3.id_dispoparc AND t1.identifiant_local=t3.identifiant_local
	LEFT JOIN dvf.suf t4 ON t1.id_dispoparc=t4.id_dispoparc AND t1.idsuf_tmp=t4.idsuf_tmp
	LEFT JOIN dvf.volume t5 ON t1.id_dispoparc=t5.id_dispoparc AND t1.no_volume=t5.no_volume
	WHERE 
		t1."4eme_lot" IS NOT NULL 
		AND t2.id_lot IS NULL
	GROUP BY t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, surface_carrez_du_4eme_lot
	
	UNION
	
	SELECT t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, 5 as no_lot, surface_carrez_du_5eme_lot
	FROM import.dvf2 t1
	LEFT JOIN dvf.lot t2 ON t1.id_dispoparc=t2.id_dispoparc AND t2.no_lot=5
	LEFT JOIN dvf.local t3 ON t1.id_dispoparc=t3.id_dispoparc AND t1.identifiant_local=t3.identifiant_local
	LEFT JOIN dvf.suf t4 ON t1.id_dispoparc=t4.id_dispoparc AND t1.idsuf_tmp=t4.idsuf_tmp
	LEFT JOIN dvf.volume t5 ON t1.id_dispoparc=t5.id_dispoparc AND t1.no_volume=t5.no_volume
	WHERE 
		t1."5eme_lot" IS NOT NULL 
		AND t2.id_lot IS NULL
	GROUP BY t1.id_dispoparc, t3.id_local, t4.id_suf, t5.id_volume, surface_carrez_du_5eme_lot

);

-----------------
-- mutation_article_cgi
-----------------
INSERT INTO dvf.mutation_article_cgi
(
	id_mutation, id_article_cgi, ordre_article_cgi
)
(
	SELECT t2.id_mutation, t3.id_article_cgi, 1 AS ordre_article_cgi
	FROM import.dvf t
	LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document  
	LEFT JOIN dvf.ann_cgi t3 ON t."1_articles_cgi"=t3.article_cgi
	LEFT JOIN dvf.mutation_article_cgi t4 ON t2.id_mutation=t4.id_mutation AND 1=t4.ordre_article_cgi
	WHERE 
		t."1_articles_cgi" IS NOT NULL 
		AND t4.id_mutation IS NULL
	GROUP BY t2.id_mutation, t3.id_article_cgi
	
	UNION
	
	SELECT t2.id_mutation, t3.id_article_cgi, 2 AS ordre_article_cgi
	FROM import.dvf t
	LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document  
	LEFT JOIN dvf.ann_cgi t3 ON t."2_articles_cgi"=t3.article_cgi
	LEFT JOIN dvf.mutation_article_cgi t4 ON t2.id_mutation=t4.id_mutation AND 2=t4.ordre_article_cgi
	WHERE 
		t."2_articles_cgi" IS NOT NULL 
		AND t4.id_mutation IS NULL
	GROUP BY t2.id_mutation, t3.id_article_cgi
	
	UNION
	
	SELECT t2.id_mutation, t3.id_article_cgi, 3 AS ordre_article_cgi
	FROM import.dvf t
	LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document  
	LEFT JOIN dvf.ann_cgi t3 ON t."3_articles_cgi"=t3.article_cgi
	LEFT JOIN dvf.mutation_article_cgi t4 ON t2.id_mutation=t4.id_mutation AND 3=t4.ordre_article_cgi
	WHERE 
		t."3_articles_cgi" IS NOT NULL 
		AND t4.id_mutation IS NULL
	GROUP BY t2.id_mutation, t3.id_article_cgi
	
	UNION
	
	SELECT t2.id_mutation, t3.id_article_cgi, 4 AS ordre_article_cgi
	FROM import.dvf t
	LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document  
	LEFT JOIN dvf.ann_cgi t3 ON t."4_articles_cgi"=t3.article_cgi
	LEFT JOIN dvf.mutation_article_cgi t4 ON t2.id_mutation=t4.id_mutation AND 4=t4.ordre_article_cgi
	WHERE 
		t."4_articles_cgi" IS NOT NULL 
		AND t4.id_mutation IS NULL
	GROUP BY t2.id_mutation, t3.id_article_cgi
	
	UNION
	
	SELECT t2.id_mutation, t3.id_article_cgi, 5 AS ordre_article_cgi
	FROM import.dvf t
	LEFT JOIN dvf.mutation t2 ON t.code_service_ch=t2.code_service_ch AND t.reference_document=t2.reference_document  
	LEFT JOIN dvf.ann_cgi t3 ON t."5_articles_cgi"=t3.article_cgi
	LEFT JOIN dvf.mutation_article_cgi t4 ON t2.id_mutation=t4.id_mutation AND 5=t4.ordre_article_cgi
	WHERE 
		t."5_articles_cgi" IS NOT NULL 
		AND t4.id_mutation IS NULL
	GROUP BY t2.id_mutation, t3.id_article_cgi
);

-----------------
--> TABLE TEMPORAIRE POUR TABLE DE CORRESPONDANCE AVEC ADRESSES
-----------------

----DROP TABLE IF EXISTS import.tmp_adresse_dispoparc_local;
CREATE TABLE import.tmp_adresse_dispoparc_local AS
(
	SELECT t3.id_adresse, t2.id_local, t.id_dispoparc
	FROM import.dvf2 t
	LEFT JOIN dvf.local t2 ON t.id_dispoparc=t2.id_dispoparc AND t.identifiant_local=t2.identifiant_local
	LEFT JOIN dvf.adresse t3 ON t.idadr_tmp=t3.idadr_tmp
);

	-----------------
	-- adresse_dispoparc
	-----------------
	INSERT INTO dvf.adresse_dispoparc 
	(
		id_adresse, id_dispoparc
	)
	(
		SELECT t1.id_adresse, t1.id_dispoparc
		FROM import.tmp_adresse_dispoparc_local t1
		LEFT JOIN dvf.adresse_dispoparc t2
		ON t1.id_adresse=t2.id_adresse AND t1.id_dispoparc=t2.id_dispoparc
		WHERE 
			t1.id_adresse IS NOT NULL
			AND t1.id_dispoparc IS NOT NULL
			AND t2.id_adresse IS NULL
			AND t2.id_dispoparc IS NULL
		GROUP BY t1.id_adresse, t1.id_dispoparc
		--ORDER BY id_adresse, id_dispoparc
	);

	-----------------
	-- adresse_local
	-----------------
	INSERT INTO dvf.adresse_local 
	(
		id_adresse, id_local
	)
	(
		SELECT t1.id_adresse, t1.id_local
		FROM import.tmp_adresse_dispoparc_local t1
		LEFT JOIN dvf.adresse_local t2
		ON t1.id_adresse=t2.id_adresse AND t1.id_local=t2.id_local
		WHERE 
			t1.id_adresse IS NOT NULL
			AND t1.id_local IS NOT NULL
			AND t2.id_adresse IS NULL
			AND t2.id_local IS NULL
		GROUP BY t1.id_adresse, t1.id_local
		--ORDER BY id_adresse, id_dispoparc
	);
	
	
DROP TABLE IF EXISTS import.dvf;
DROP TABLE IF EXISTS import.dvf1;
DROP TABLE IF EXISTS import.dvf2;
DROP TABLE IF EXISTS import.tmp_adresse_dispoparc_local;
DROP TABLE IF EXISTS import.tmp_suf;

DROP SCHEMA IF EXISTS import ;




