# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IZHuRRPI
                                 A QGIS plugin
 Identification des Zones Humides Ralentissant les Ruisselements et Prévenant
 Inondations
                              -------------------
        begin                : 2019-09-01
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import sys, os, os.path, sqlite3, shutil, csv, subprocess,  unicodedata
import processing
import time
start_time = time.time()


from .boite import boite


class creerbase():

    def select_dossier_base(self):
        base = QFileDialog.getExistingDirectory(self, u"sélectionner un dossier pour la base")
        self.lineEdit_base.setText(base)

    def select_dossier_zh(self):
        zh, _ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier shp de la zone humide ",
                                            "C:/", '*.shp *.SHP')
        self.lineEdit_zh.setText(zh)

    def select_ze(self):
        ze, _ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier shp de la zone d'étude",
                                            "C:/", '*.shp *.SHP')
        self.lineEdit_ze.setText(ze)

    def select_ceau(self):
        ceau, _ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier shp des cours d'eau",
                                              "C:/", '*.shp *.SHP')
        self.lineEdit_ceau.setText(ceau)

    def select_ocs(self):
        ocs, _ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier shp de l'occupation du sol",
                                             "C:/", '*.shp *.SHP')
        self.lineEdit_ocs.setText(ocs)

    def select_dossier_mnt(self):
        mnt = QFileDialog.getExistingDirectory(self, u"sélectionner le dossier contenant les mnt")
        self.lineEdit_mnt.setText(mnt)

    def select_lidar(self):
        lidar, _ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier shp du Lidar",
                                             "C:/", '*.shp *.SHP')
        self.lineEdit_lidar.setText(lidar)

    def selec_parce(self):
        self.doubleSpinBox_parce.setText(parce)

    def select_pc_zh(self):
        self.doubleSpinBox_pc_zh.setText(pc_zh)

    def select_sim_ceau(self):
        self.doubleSpinBox_sim_ceau.setText(sim_ceau)

    def create_base(self):


        ### recuperation des autres parametres
        dossier_base = self.lineEdit_base.text()
        nom_base = self.lineEdit_nom_base.text()

        path_base = os.path.join(dossier_base + '/', nom_base + '.sqlite')

        zh = self.lineEdit_zh.text()

        ze = self.lineEdit_ze.text()
        name_ze, extension = os.path.splitext(ze)
        name_ze =(name_ze.lower()).split('/')[-1]

        parce = self.doubleSpinBox_parce.text()
        parce = parce.replace(',','.')
        ceau = self.lineEdit_ceau.text()
        name_ceau, extension = os.path.splitext(ceau)
        name_ceau = (name_ceau.lower()).split('/')[-1]
        extension_ceau = extension
        ocs = self.lineEdit_ocs.text()
        mnt = self.lineEdit_mnt.text()
        lidar = self.lineEdit_lidar.text()
        pc_zh = self.doubleSpinBox_pc_zh.text()
        pc_zh = pc_zh.replace(',','.')
        sim_ceau = self.doubleSpinBox_sim_ceau.text()
        sim_ceau = sim_ceau.replace(',', '.')



################### Dernieres verifications avant lancement ###################

        ####### Verification du remplissage des champs #######

        if dossier_base == '':
            boite.boite_rouge(self.toolButton_base, self.lineEdit_base, self.label_base)
            boite.message(self, u"Vous n'avez pas renseigné de dossier pour l'analyse",
                          u"Remplisser le champ avant de relancer").exec_()
            return

        if nom_base == '':
            self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #B3C21A}')
            self.label_nom_base.setStyleSheet('QLabel {color:#B3C21A}')
            boite.message(self, u"Vous n'avez pas renseigné de nom pour l'analyse",
                          u"Remplisser le champ avant de relancer").exec_()
            return

        if zh == '':
            boite.boite_rouge(self.toolButton_zh, self.lineEdit_zh, self.label_zh)
            boite.message(self, u"Vous n'avez pas renseigné de zone humide",
                          u"Remplisser le champ avant de relancer").exec_()
            return

        if ze == '':
            boite.boite_rouge(self.toolButton_ze, self.lineEdit_ze, self.label_ze)
            boite.message(self, u"Vous n'avez pas renseigné de zone d'étude",
                          u"Remplisser le champ avant de relancer").exec_()
            return


        if ceau == '':
            boite.boite_rouge(self.toolButton_ceau, self.lineEdit_ceau, self.label_ceau)
            boite.message(self, u"Vous n'avez pas renseigné de cours d'eau",
                          u"Remplisser le champ avant de relancer").exec_()
            return

        if ocs == '':
            boite.boite_rouge(self.toolButton_ocs, self.lineEdit_ocs, self.label_ocs)
            boite.message(self, u"Vous n'avez pas renseigné d'occupation du sol",
                          u"Remplisser le champ avant de relancer").exec_()
            return

        if mnt == '':
            boite.boite_rouge(self.toolButton_mnt, self.lineEdit_mnt, self.label_mnt)
            boite.message(self, u"Vous n'avez pas renseigné de dossier contenant les MNT",
                          u"Remplisser le champ avant de relancer").exec_()
            return



        ####### Verification de l'existance d'une base du même nom #######

        if nom_base != '':
            a = os.listdir(dossier_base)
            if nom_base + ".sqlite" in a:
                self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
                self.label_nom_base.setStyleSheet('QLabel {color:#FF0000}')
                boite.message(self, u"la base " + nom_base + u" existe déjà",
                              u"Renommer l'analyse avant de relancer").exec_()
                return

        a0 = u"vérification des données d'entrée réussie !"
        t = "time elapsed: {:.2f}s".format(time.time() - start_time)
        details = ''
        details += "\n" + a0 + " (" + t + ")"
        self.detailsPlainTextEdit_2.appendPlainText(details)


        ####### Rappel si analyse avec le LIDAR souhaité #######
        if self.checkBox_2.isChecked():
            msg = QMessageBox.question(self,u"ATTENTION !!",
                                       u"Vous avez choisi DE NE PAS REALISER l'analyse Lidar !! \n Est-ce vraiment votre souhait ? \n Si oui, veuillez en tenir compte lors du calcul des notes",
                                       QMessageBox.Yes | QMessageBox.No, QMessageBox.Yes)

            if msg == QMessageBox.No :
                return
            else :
                pass

        if not self.checkBox_2.isChecked():
            msg = QMessageBox.question(self, u"ATTENTION !!",
                                       u"Vous avez choisi DE REALISER l'analyse Lidar !!\n Est-ce vraiment votre souhait ?\n Si oui, veuillez en tenir compte lors du calcul des notes",
                                       QMessageBox.Yes | QMessageBox.No, QMessageBox.Yes)

            if msg == QMessageBox.No:
                return
            else:

                if lidar == '':
                    boite.boite_rouge(self.toolButton_lidar, self.lineEdit_lidar, self.label_lidar)
                    boite.message(self, u"Vous n'avez pas renseigné de Lidar",
                                  u"Remplisser le champ avant de relancer").exec_()
                    return


# ----------------------------------------------------------------------------------------------------------------------
# ------------------------------------------------- TRAITEMENTS --------------------------------------------------------
# ----------------------------------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------
# -------------- Creation de la base et import de la zone d'étude --------------
# ------------------------------------------------------------------------------

        nom_ligne_com = 'ogr2ogr -f SQLite -dsco SPATIALITE=YES %s %s -nln %s -a_srs EPSG:2154 -gt unlimited' \
                        % (path_base, ze, name_ze)

        try:
            subprocess.run(nom_ligne_com, shell=True)

            a1 = u"création de la base et import de la zone d'étude réussis !"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a1 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(2)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de la création de la base : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ------------------------- connexion a la base -------------------------------
# ------------------------------------------------------------------------------

        conn = sqlite3.dbapi2.connect(path_base)
        cur = conn.cursor()
        conn.enable_load_extension(True)
        conn.execute("SELECT load_extension('mod_spatialite')")


# ------------------------------------------------------------------------------
# ---------------------- création de l'index spatial pour ze -------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = "SELECT CreateSpatialIndex('%s','GEOMETRY');" % (name_ze)
            cur.execute(req_sql)
        except BaseException as erreur:
            boite.message(self, str(erreur),
                              u"Erreur  lors de la création de l index spatial pour la ze : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ----------- Calcul de l'emprise spatiale du buffer 1 km de la zone d'étude -------------
# ------------------------------------------------------------------------------

        list_coordonnees = []
        try:
            req_sql = """
                    SELECT
                        st_minx(st_envelope(st_buffer(geometry, 1000))) as xmin,
                        st_miny(st_envelope(st_buffer(geometry, 1000))) as ymin,
                        st_maxx(st_envelope(st_buffer(geometry, 1000))) as xmax,
                        st_maxy(st_envelope(st_buffer(geometry, 1000))) as ymax
                    FROM  {}
                    """\
                    .format(name_ze)
            cur.execute(req_sql)

            tables = cur.fetchall()
            for table in tables:
                xmin = table[0]
                ymin = table[1]
                xmax = table[2]
                ymax = table[3]
                list_coordonnees.append(xmin)
                list_coordonnees.append(ymin)
                list_coordonnees.append(xmax)
                list_coordonnees.append(ymax)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de la définition de l'étendue : contacter l'admin").exec_()
            return
            pass

# -------------------------------------------------------------------------------
# -------------------- création d'un dossier temporaire ---------------------------
#  ------------------------------------------------------------------------------

        dossier_temp = os.path.join(dossier_base + '/' + nom_base)
        try:
            shutil.rmtree(dossier_temp)
        except:
            pass
        try:
            os.mkdir(dossier_temp)
        except BaseException as erreur:
            boite.message(self, str(erreur),
                            u" Erreur lors de la creation du dossier temporaire : contacter l'admin").exec_()


# ------------------------------------------------------------------------------
# ------------------------------ Creation de la grille du parcellaire ----------
# ------------------------------------------------------------------------------

        output_grid = dossier_temp + "/grille.shp"
        extend = str(xmin) +',' +str(xmax) +',' +str(ymin)+',' +str(ymax) + ' [EPSG:2154]'
        print (extend)
        print(parce)
        try:
            grid = processing.run('qgis:creategrid',
                                  {'CRS': 'EPSG:2154',
                                   'EXTENT': extend + '[EPSG:2154]' ,
                                   'HOVERLAY': 0, 'HSPACING': parce,
                                   'OUTPUT': output_grid, 'TYPE': 2, 'VOVERLAY': 0, 'VSPACING': parce})
            a34 = u"Création de la grille parcellaire réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a34 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            print (grid)
        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de la création de la grille parcellaire : contacter l'admin").exec_()
            return
            pass

# ------------------------------------------------------------------------------
# ------------------------------ import du parcellaire -------------------------
# ------------------------------------------------------------------------------

        nom_ligne_com = 'ogr2ogr -append {} {} -nln {} ' \
                        '-a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI ' \
                        '-lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry ' \
                        '-spat {} {} {} {}'\
                        .format(path_base, output_grid, "parcelle", xmin, ymin, xmax, ymax)

        try:
            subprocess.run(nom_ligne_com, shell=True)

            a2 = u"Import du parcellaire réussi !"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a2 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(4)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de l'import du parcellaire: contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ------------- découpage du parcellaire dans la zone d'étude ------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS n_parcelle_bdp_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE n_parcelle_bdp_{} as
                    SELECT b.ogc_fid,
                        st_Multi(st_makevalid(st_intersection(st_makevalid(a.geometry),st_makevalid(b.geometry))))
                        as geometry
                    FROM {} as a, {} as b
                    WHERE st_intersects(st_makevalid(a.geometry),st_makevalid(b.geometry))
                    AND a.ROWID IN
                        (SELECT ROWID FROM SpatialIndex WHERE f_table_name = {} AND search_frame = a.geometry)
                      """\
                .format(nom_base, name_ze,"parcelle", '"' + name_ze + '"')
            cur.execute(req_sql)

            req_sql = "SELECT RecoverGeometryColumn('n_parcelle_bdp_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')".format(
                nom_base)
            cur.execute(req_sql)

            req_sql = "SELECT RecoverGeometryColumn('n_parcelle_bdp_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')".format(
                nom_base)
            req_sql = "SELECT CreateSpatialIndex('n_parcelle_bdp_{}','GEOMETRY');".format(nom_base)
            cur.execute(req_sql)
            conn.commit()


            a3 = u"Découpage du parcellaire réussi !"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a3 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(6)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors du decoupage du parcellaire : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ------ Création de la zone tampon de 1km autour de la zone d'étude -----------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS perimetre_ze_buff_100_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE perimetre_ze_buff_100_{} as
                    SELECT ogc_fid, st_Multi(st_buffer(a.geometry,1000)) as geometry
                    FROM {} as a
                    """\
                    .format(nom_base, name_ze)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('perimetre_ze_buff_100_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                        """.format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                      ('perimetre_ze_buff_100_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT CreateSpatialIndex('perimetre_ze_buff_100_{}','GEOMETRY');
                    """\
                    .format(nom_base)
            cur.execute(req_sql)
            conn.commit()


            a4 = u"Création de la zone tampon de 1km autour de la zone d'étude réussie !"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a4 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(8)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de l'indexation spatiale de la zone tampon "
                                             u"de 1km autour de la zone d'étude : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# -------------------- import des cours d'eau de la BD TOPO --------------------
# ------------------------------------------------------------------------------

        ####### définition des noms de champs variables #######

        layer = QgsVectorLayer(r"D:\Documents\teletravail\a_izhurrpi\n_troncon_hydrographique_bdt_073_2019.shp", "n_troncon_hydrographique_bdt_073_2019.shp", "ogr")

        chp_reg = ''

        for field in layer.fields():
            if field.name() in ("regime","persistanc"):
                chp_reg = field.name()

        chp_nom = ''

        for field in layer.fields():
            if field.name() in ("nom","nom_c_eau"):
                chp_nom = field.name()

        ####### import de toutes les tables de la ceau #######

        ##### Si encodage en UTF-8 ####

        if not self.checkBox.isChecked():

            nom_ligne_com = 'ogr2ogr -append {} {} -nln {}   ' \
                            '-a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI -lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry' \
                            ' -spat {} {} {} {}'.format(path_base, ceau, "troncon_cours_eau", xmin, ymin, xmax, ymax)
            try:
                print (nom_ligne_com)
                subprocess.run(nom_ligne_com, shell=True)

                a5 = u"Import des troncons cours d'eau de la BD TOPO réussi !"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a5 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(10)

            except BaseException as erreur:
                boite.message(self, str(erreur), u"Erreur lors de l'import des troncons cours d'eau"
                                                     u" de la BD TOPO : contacter l'admin").exec_()
                return
                pass



        ##### Si encodage en ISO-8859-1 ####

        elif self.checkBox.isChecked():

            #### creation du dossier temporaire d accueil des shp ####

            temp_shp = os.path.join(dossier_base +'/temp_shp')
            try:
                shutil.rmtree(temp_shp)
            except BaseException as erreur:
                pass

            try:
                os.mkdir(temp_shp)
                print (temp_shp)
            except BaseException as erreur:
                boite.message(self, str(erreur), u" Erreur lors de la creation du 1er dossier temporaire d'accueil du shp (import des tables de la BD TOPO® (ed < 171)) : contacter l'admin").exec_()
                return
                pass

            #### copie des shp d origine dans le dossier temporaire ####
            path = ceau
            table = name_ceau.lower()
            path_temp = os.path.join(temp_shp + '/', table + "_temp.SHP")

            nom_ligne_com = 'ogr2ogr -f "ESRI Shapefile" %s %s  -spat %s %s %s %s ' \
                                                            % (path_temp, path, xmin, ymin, xmax, ymax)
            print(nom_ligne_com)
            try:
                subprocess.run(nom_ligne_com, shell=True)
            except BaseException as erreur:
                boite.message(self, str(erreur),u" Erreur lors de la 1er copie des tables de la BD TOPO® (ed < 171) : contacter l'admin").exec_()
                return
                pass


            #### creation du deuxieme dossier temporaire d accueil des shp ####

            temp_shp2 = os.path.join(dossier_base +'/temp_shp2')
            try:
                shutil.rmtree(temp_shp2)
            except:
                pass
            try:
                os.mkdir(temp_shp2)
            except BaseException as erreur:
                boite.message(self, str(erreur),
                              u" Erreur lors de la creation du 2ème dossier temporaire d'accueil du shp (import des tables de la BD TOPO® (ed < 171)) : contacter l'admin").exec_()
                return
                pass

            #### copie des shp du premier dossier temporaire dans le deuxieme dossier temporaire ####


            path = os.path.join(temp_shp + '/', table + "_temp.SHP")
            path_temp = os.path.join(temp_shp2 + '/', table + "_temp.shp")

            nom_ligne_com = 'ogr2ogr -f "ESRI Shapefile" %s %s  -spat %s %s %s %s ' \
                            % (path_temp, path, xmin, ymin, xmax, ymax)
            print(nom_ligne_com)
            try:
                subprocess.run(nom_ligne_com, shell=True)
            except BaseException as erreur:
                boite.message(self, str(erreur),
                              u" Erreur lors de la 1er copie des tables de la BD TOPO® (ed < 171) : contacter l'admin").exec_()
                return
                pass

            name_ceau2, extension = os.path.splitext(path_temp)
            name_ceau2 = (name_ceau2.lower()).split('/')[-1]

            nom_ligne_com = 'ogr2ogr -append {} {} -nln {} ' \
                            '-a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI ' \
                            '-lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry ' \
                            '-spat {} {} {} {} -sql "SELECT * FROM {} WHERE {} in ({})" '\
                            .format(path_base, path_temp, "troncon_cours_eau", xmin, ymin, xmax, ymax,name_ceau2, chp_reg, "'Permanent','Intermittent'")
            try:
                print (nom_ligne_com)
                subprocess.run(nom_ligne_com, shell=True)

                a5 = u"Import des troncons cours d'eau de la BD TOPO réussi !"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a5 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(10)

            except BaseException as erreur:
                boite.message(self, str(erreur), u"Erreur lors de l'import des troncons cours d'eau"
                                                 u" de la BD TOPO : contacter l'admin").exec_()
                return
                pass

            #### suppression des 2 dossiers temporaires ###
            shutil.rmtree(temp_shp)
            shutil.rmtree(temp_shp2)

# ------------------------------------------------------------------------------
# --------- Troncon des cours d'eau dans la zone d'étude +  buffer 1km ---------
# ------------------------------------------------------------------------------

        try :
            req_sql = 'DROP TABLE IF EXISTS inventaire_cours_eau_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE inventaire_cours_eau_{} as
                    SELECT b.ogc_fid, b.{}, b.{},
                        st_Multi(st_makevalid(st_intersection(st_makevalid(a.geometry),
                        st_makevalid(b.geometry)))) as geometry
                    FROM perimetre_ze_buff_100_{} as a, {} as b
                    WHERE st_intersects(st_makevalid(a.geometry),
                        st_makevalid(b.geometry))
                        AND a.ROWID IN
                        (SELECT ROWID FROM SpatialIndex WHERE f_table_name = {} AND search_frame = b.geometry)
                    """\
                    .format(nom_base, chp_reg, chp_nom, nom_base, "troncon_cours_eau",
                            "'" + "perimetre_ze_buff_100_" + nom_base + "'")
            cur.execute(req_sql)
            print(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('inventaire_cours_eau_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XYZ')
                        """\
                        .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('inventaire_cours_eau_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XY')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT CreateSpatialIndex('inventaire_cours_eau_{}','GEOMETRY');
                    """\
                    .format(nom_base)
            cur.execute(req_sql)
            conn.commit()


            a6 = u"Découpage des troncons cours d'eau de la BD TOPO dans le buffer 1km de la zone d'étude réussi  !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a6 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(12)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors du découpage des cours d'eau dans le buffer 1km"
                          u" de la zone d'étude : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ----- Sélection des cours d'eau permanent Troncon des cours d'eau ------------
# -----------------dans la zone d'étude +  buffer 1km --------------------------
# ------------------------------------------------------------------------------

        try :
            req_sql = 'DROP TABLE IF EXISTS cours_eau_permanents_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE cours_eau_permanents_{} as
                    SELECT *
                    FROM inventaire_cours_eau_{}
                    WHERE {} = "Permanent"
                    """\
                    .format(nom_base, nom_base, chp_reg)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('cours_eau_permanents_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XYZ')
                        """\
                        .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('cours_eau_permanents_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XY')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT CreateSpatialIndex('cours_eau_permanents_{}','GEOMETRY');
                    """\
                    .format(nom_base)
            cur.execute(req_sql)
            conn.commit()


            a7 = u"Sélection des cours d'eau permanents dans le buffer 1km de la zone d'étude réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a7 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(14)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de la sélection des cours d'eau permanents "
                          u"dans le buffer 1km de la zone d'étude : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ------- Création d'un buffer de 500m autour des cours d'eau permanent --------
# ------------------------------------------------------------------------------

        try :
            req_sql = 'DROP TABLE IF EXISTS tampon_500_m_cours_eau_permanents_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE tampon_500_m_cours_eau_permanents_{} as
                    SELECT min(ogc_fid) as ogc_fid, st_multi(st_union(st_buffer(a.geometry,500))) as geometry
                    FROM cours_eau_permanents_{} as a
                    """\
                    .format(nom_base,nom_base, "'" + "cours_eau_permanents_" + nom_base + '"')
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('tampon_500_m_cours_eau_permanents_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('tampon_500_m_cours_eau_permanents_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT CreateSpatialIndex('tampon_500_m_cours_eau_permanents_{}','GEOMETRY');
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            a8 = u"Création du buffer de 500m autour des cours d'eau permanents réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a8 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(16)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de la création du buffer de 500m autour des cours "
                          u"d'eau permanents : contacter l'admin").exec_()
            return
            pass

# ------------------------------------------------------------------------------
# -------------------------- import des zones humides --------------------------
# ------------------------------------------------------------------------------

        nom_ligne_com = 'ogr2ogr -append {} {} -nln {} ' \
                        '-a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI ' \
                        '-lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry ' \
                        '-spat {} {} {} {}'\
                        .format(path_base, zh, "zone_humide_" + nom_base, xmin, ymin, xmax, ymax)

        try:
            subprocess.run(nom_ligne_com, shell=True)

            a5 = u"Import des zones humides réussi !"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a5 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(18)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de l'import des zones humides : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ----------------------- Arrêt et reconnexion à la base ----------------------
# ------------------------------------------------------------------------------
        conn.commit()
        conn.close()
        conn = sqlite3.dbapi2.connect(path_base)
        cur = conn.cursor()
        conn.enable_load_extension(True)
        conn.execute("SELECT load_extension('mod_spatialite')")


# ------------------------------------------------------------------------------
# ------ Récupération des champs contenus dans la table des zone humide --------
# ------------------------------------------------------------------------------

        liste_chp_zh = []
        req_sql = "PRAGMA table_info('{}');".format("zone_humide_" + nom_base)
        cur.execute(req_sql)
        resultat = cur.fetchall()

        for champ in resultat:
            if champ[1] != "geometry" and champ[1] != "ogc_fid":
                liste_chp_zh.append(champ[1])
        liste_chp_zh = ((str(liste_chp_zh).replace('[', '')).replace(']', '')).replace("'", '')


# ------------------------------------------------------------------------------
# ------ Sélection de toutes les zones humides situé dnas le tampon 500m -------
# --------------------- des cours d'eau permanents -----------------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS zone_humide_t500_cep_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE zone_humide_t500_cep_{} as
                    SELECT {}, st_multi(st_makevalid(st_intersection(a.geometry, b.geometry))) as geometry
                    FROM tampon_500_m_cours_eau_permanents_{} as a, zone_humide_{} as b
                    WHERE st_intersects(a.geometry, b.geometry)
                    AND a.ROWID IN
                        (SELECT ROWID
                            FROM SpatialIndex WHERE f_table_name = {}
                            AND search_frame = b.geometry)
                    ;
                    """\
                    .format(nom_base,liste_chp_zh, nom_base, nom_base,
                            '"' + "tampon_500_m_cours_eau_permanents_" + nom_base + '"')
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('zone_humide_t500_cep_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('zone_humide_t500_cep_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT CreateSpatialIndex('zone_humide_t500_cep_{}','GEOMETRY');
                    """\
                    .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a9 = u"Sélection des zones humides dans le buffer de 500m autour des cours d'eau permanents réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a9 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(20)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de la selection des zones humides dans le buffer "
                          u"de 500m autour des cours d'eau permanents : contacter l'admin").exec_()
            return
            pass

# ------------------------------------------------------------------------------
# ------------------------- Union des zonnes humide ----------------------------
# ------------------------------------------------------------------------------

        try :
            req_sql = 'DROP TABLE IF EXISTS zone_humide_t500_cep_union_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE zone_humide_t500_cep_union_{} as
                    SELECT "1" as id, st_union(a.geometry) as geometry
                    FROM zone_humide_t500_cep_{} as a;
                    """\
                .format(nom_base,nom_base)
            cur.execute(req_sql)

            req_sql = """
                SELECT RecoverGeometryColumn
                    ('zone_humide_t500_cep_union_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                                """ \
                .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                    ('zone_humide_t500_cep_union_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                    """ \
                .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT CreateSpatialIndex
                     ('zone_humide_t500_cep_union_{}','GEOMETRY');
                    """ \
                .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a10 = u"Union des zones humides réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a10 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(20)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de l'union des zones humides"
                          u" des zones humides : contacter l'admin").exec_()
            return
            pass

# ------------------------------------------------------------------------------
# ---------- Calcul de la superficie de chaque parcelle en ZH ------------------
# ----------------et du pourcentage de parcelle en ZH --------------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS relation_parcelle_zh_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE relation_parcelle_zh_{} as
                    WITH a as (
                    SELECT ROW_NUMBER() OVER(ORDER BY b.ogc_fid) AS id, b.ogc_fid as id_parcelle,
                        b.geometry,
                        st_area(st_makevalid(st_intersection(st_makevalid(a.geometry),
                        st_makevalid(b.geometry)))) as area,
                        st_area(st_makevalid(st_intersection(st_makevalid(a.geometry),
                        st_makevalid(b.geometry))))/st_area(b.geometry)*100 as pourc_area
                    FROM zone_humide_t500_cep_union_{} as a, {} as b
                    WHERE st_intersects(a.geometry, b.geometry)
                    AND a.ROWID IN
                        (SELECT ROWID
                            FROM SpatialIndex WHERE f_table_name = {}
                            AND search_frame = b.geometry)
                    GROUP BY b.geometry
                    )
                    SELECT a.*, {}
                    FROM a, zone_humide_t500_cep_{} as b
                    WHERE st_intersects(a.geometry, b.geometry)
                    """\
                .format(nom_base,nom_base, "parcelle",
                        '"' + "zone_humide_t500_cep_union_" + nom_base + '"',liste_chp_zh, nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('relation_parcelle_zh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('relation_parcelle_zh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT CreateSpatialIndex
                        ('relation_parcelle_zh_{}','GEOMETRY');
                    """\
                    .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a10 = u"Sélection des parcelles intersectants des zones humides réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a10 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(20)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de la sélection des parcelles intersectants"
                          u" des zones humides : contacter l'admin").exec_()
            return
            pass

# ------------------------------------------------------------------------------
# ------------- Selection des parcelles dont x% en zone humide -----------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS selection_parcelle_zh_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                    CREATE TABLE selection_parcelle_zh_{} as
                    SELECT *
                    FROM relation_parcelle_zh_{} as a
                    WHERE a.pourc_area > {}
                    """\
                .format(nom_base,nom_base,pc_zh)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('selection_parcelle_zh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT RecoverGeometryColumn
                        ('selection_parcelle_zh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                    """\
                    .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                    SELECT CreateSpatialIndex('selection_parcelle_zh_{}','GEOMETRY');
                    """\
                    .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a11 = u"Sélection des parcelles ayant plus de " + pc_zh + "% de leur superficie en zone humide réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a11 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(22)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                          u"Erreur lors de la selection des parcelles ayant plus de "
                          + pc_zh + "% de leur superficie en zone humide : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# -------- fusion de tous les cours d'eau permanents ayant le même nom ---------
# ------------------------------------------------------------------------------
        try:
           req_sql = 'DROP TABLE IF EXISTS cours_eau_permanents_fusion_{}'.format(nom_base)
           cur.execute(req_sql)
           req_sql = """
                   CREATE TABLE cours_eau_permanents_fusion_{} as
                   SELECT min(ogc_fid) as ogc_fid, {}, {},
                       st_multi(st_union(geometry)) as geometry
                   FROM cours_eau_permanents_{} as a
                   GROUP BY {}
                   """\
                   .format(nom_base, chp_reg, chp_nom, nom_base, chp_nom)
           cur.execute(req_sql)

           req_sql = """
                   SELECT RecoverGeometryColumn
                       ('cours_eau_permanents_fusion_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XYZ')
                   """\
                   .format(nom_base)
           cur.execute(req_sql)

           req_sql = """
                   SELECT RecoverGeometryColumn
                       ('cours_eau_permanents_fusion_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XY')
                   """\
                   .format(nom_base)
           cur.execute(req_sql)

           req_sql = """
                   SELECT CreateSpatialIndex('cours_eau_permanents_fusion_{}','GEOMETRY');
                   """\
                   .format(nom_base)
           cur.execute(req_sql)
           conn.commit()

           a12 = u"Fusion de tous les cours d'eau permanents ayant le même nom réussie !!"
           t = "time elapsed: {:.2f}s".format(time.time() - start_time)
           details = ''
           details += "\n" + a12 + " (" + t + ")"
           self.detailsPlainTextEdit_2.appendPlainText(details)
           self.progressBar.setValue(24)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la fusion de tous les cours d'eau permanents "
                         u"ayant le même nom : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# -------- Intersection de zone humide tampon 500m cep avec les parcelles ------
# ------------------sélectionnées à partir du pourcentage choisi ---------------
# ----------------------(table selection_parcelle_zh_gemapi1) ------------------
# ------------------------------------------------------------------------------

        try:
           req_sql = 'DROP TABLE IF EXISTS zh_parcelle_ppour_{}'.format(nom_base)
           cur.execute(req_sql)
           req_sql = """
                   CREATE TABLE zh_parcelle_ppour_{} as
                   WITH b as (
                   WITH a as (
                   SELECT a.*, b.id id_select, b.id_parcelle,
                       st_multi(st_makevalid(st_intersection(a.geometry, b.geometry))) as GEOM
                   FROM zone_humide_t500_cep_{} as a, selection_parcelle_zh_{} as b
                   WHERE st_intersects(a.geometry,b.geometry)
                   AND a.ROWID IN
                       (SELECT ROWID
                           FROM SpatialIndex WHERE f_table_name = {}
                           AND search_frame = b.geometry)
                    )
                    SELECT ROW_NUMBER() OVER(ORDER BY id_parcelle) AS id,  *
                    FROM a)
                    SELECT *
                    FROM b
                    GROUP BY geom
                    HAVING min(id)
                   """\
                   .format(nom_base,nom_base,nom_base,
                           '"' + "zone_humide_t500_cep_" + nom_base + '"')
           cur.execute(req_sql)

           req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_{}', 'GEOM', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
           cur.execute(req_sql)

           req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_{}', 'GEOM', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
           cur.execute(req_sql)

           req_sql = """
                   SELECT CreateSpatialIndex('zh_parcelle_ppour_{}','GEOM');
                   """\
                   .format(nom_base)
           cur.execute(req_sql)
           conn.commit()

           a13 = u"Sélection des zones humides sur lesquelles des parcelles ont été selectionnées réussie !!"
           t = "time elapsed: {:.2f}s".format(time.time() - start_time)
           details = ''
           details += "\n" + a13 + " (" + t + ")"
           self.detailsPlainTextEdit_2.appendPlainText(details)
           self.progressBar.setValue(26)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la sélection des zones humides"
                         u" sur lesquelles des parcelles ont été selectionnées : contacter l'admin").exec_()
            return
            pass



# ------------------------------------------------------------------------------
# ------------- Buffer de 50 m autour des zones humides (parcelles) ------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS zh_t50_p_ppour_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE zh_t50_p_ppour_{} as
                   SELECT id, id_parcelle,{},
                       st_multi(st_buffer(geom,50)) as geometry
                   FROM zh_parcelle_ppour_{};
                   """\
                   .format(nom_base, liste_chp_zh, nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_t50_p_ppour_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_t50_p_ppour_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('zh_t50_p_ppour_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a15 = u"Création du buffer de 50m autour des zones humide (parcelles) réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a15 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(30)

        except BaseException as erreur:
           boite.message(self, str(erreur),
                         u"Erreur lors de la création du buffer de 50m "
                         u"autour des zones humide (parcelles) : contacter l'admin").exec_()
           return
           pass


# ------------------------------------------------------------------------------
# --------------- Sélection des cours d'eau dans le buffer de 50 m -------------
# --------------------- autour des zones humides (parcelles) -------------------
# ------------------------------------------------------------------------------
        try:
            req_sql = 'DROP TABLE IF EXISTS zh_t50_courseau_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE zh_t50_courseau_{} as
                       with un as (
                       SELECT id, id_parcelle,
                           CASE WHEN {} = "Permanent"
                               THEN st_length(st_intersection(a.geometry,b.geometry))
                               ELSE 0
                           END AS long_permanent,
                           CASE WHEN {} = "Intermittent"
                               THEN st_length(st_intersection(a.geometry,b.geometry))
                               ELSE 0
                           END AS long_intermittent,
                           b.geometry as geometry
                       FROM inventaire_cours_eau_{} as a, zh_t50_p_ppour_{} as b
                       WHERE st_intersects(a.geometry, b.geometry)
                       AND a.ROWID IN
                       (SELECT ROWID
                           FROM SpatialIndex WHERE f_table_name = {}
                           AND search_frame = b.geometry)
                   )
                   SELECT id, id_parcelle, sum(long_permanent) as long_permanent,
                       sum(long_intermittent) as long_intermittent,
                       st_multi(st_union(geometry)) as geometry
                   FROM un
                   GROUP BY id
                   """\
                   .format(nom_base, chp_reg, chp_reg, nom_base, nom_base,
                           '"' + "inventaire_cours_eau_" + nom_base + '"')
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_t50_courseau_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_t50_courseau_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('zh_t50_courseau_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a16 = u"Sélection des cours d'eau dans le buffer de 50 m autour des zones humides (parcelles) réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a16 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(32)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la sélection des cours d'eau dans le buffer de 50 m"
                         u" autour des zones humides (parcelles) : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ----------------------- Calcul de la densité de fossé ------------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS densite_fosse_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE densite_fosse_{} as
                   SELECT a.id, a.id_parcelle, long_permanent,long_intermittent,
                       CASE WHEN long_intermittent is null
                           THEN 0
                           ELSE (long_intermittent/1000)/(st_area(a.geometry)/10000)
                       END AS densite_fosse,
                       a.geometry
                   FROM zh_t50_courseau_{} as a
                   """\
                   .format(nom_base, nom_base, nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('densite_fosse_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT
                       RecoverGeometryColumn('densite_fosse_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('densite_fosse_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a17 = u"Calcul de la densité de fossé réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a17 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(34)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul de la densité de fossé : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ----------------- Calcul de la rareté des de fossé ---------------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS rarete_fosse_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE rarete_fosse_{} as
                   SELECT a.id, id_parcelle, long_permanent, long_intermittent, densite_fosse,
                       CASE WHEN densite_fosse >= 0.14
                           THEN 0
                           ELSE 1-(densite_fosse*7.134)
                       END AS rarete_fosse,
                       a.geometry
                   FROM densite_fosse_{} as a;
                   """\
               .format(nom_base, nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('rarete_fosse_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
               .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('rarete_fosse_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('rarete_fosse_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a18 = u"Calcul de la rareté de fossé réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a18 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(36)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul de la rareté des fossés : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# --------------------- import du couvert végétal ------------------------------
# ------------------------------------------------------------------------------

        nom_ligne_com = 'ogr2ogr -append {} {} -nln {} ' \
                       '-a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI ' \
                       '-lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry ' \
                       '-spat {} {} {} {}'\
                       .format(path_base, ocs, "couvert_vegetal_1_" + nom_base, xmin, ymin, xmax, ymax)

        try:
            subprocess.run(nom_ligne_com, shell=True)

            a19 = u"Import du couvert végétal réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a19 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(38)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de l'import du couvert végétal : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# --------------- Correction de la geometrie du couvert vegetal ----------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS couvert_vegetal_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE couvert_vegetal_{} as
                   SELECT ogc_fid,
                       CASE WHEN classe in ('11','41','42','43','44','45','46','51','53') THEN 'Pas de couvert végétal'
                           WHEN classe in ('12','34','211') THEN 'Couvert bas'
                           WHEN classe in ('36','221','222') THEN 'Couvert intermédiaire'
                           ELSE 'Couvert haut'
                       END as couv_veget,
                       CASE WHEN st_isvalid(a.geometry) is "FALSE"
                           THEN st_multi(ST_CollectionExtract(st_makevalid(a.geometry),3))
                           ELSE geometry
                       END AS geometry
                   FROM couvert_vegetal_1_{} as a;
                   """\
               .format(nom_base, nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('couvert_vegetal_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZM')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('couvert_vegetal_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(
               nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('couvert_vegetal_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a20 = u"Correction géométrique du couvert végétal réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a20 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(40)


        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la correction de la geometrie"
                         u" du couvert vegetal : contacter l'admin").exec_()
            return
            pass

# ------------------------------------------------------------------------------
# ---- Calcul de la surface de chaque couvert pour chaque parcelle partie 1 ----
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS couvert_vegetal_surfzh_p1_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE couvert_vegetal_surfzh_p1_{} as
                   SELECT id, id_parcelle, couv_veget,
                       st_multi(st_intersection(a.geom,b.geometry)) as geometry
                   FROM zh_parcelle_ppour_{} as a, couvert_vegetal_{} as b
                   WHERE st_intersects(a.geom,b.geometry)
                       AND a.ROWID IN
                       (SELECT ROWID
                           FROM SpatialIndex WHERE f_table_name = {}
                           AND search_frame = b.geometry)
                   ;
                   """\
               .format(nom_base,nom_base,nom_base,
                       '"' + "zh_parcelle_ppour_" + nom_base + '"')
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('couvert_vegetal_surfzh_p1_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('couvert_vegetal_surfzh_p1_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('couvert_vegetal_surfzh_p1_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a21 = u"Calcul de la surface du couvert vegetal (partie 1) réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a21 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(42)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul de la surface "
                         u"du couvert vegetal (partie 1) : contacter l'admin").exec_()
            return
            pass

# ------------------------------------------------------------------------------
# ---- Calcul de la surface de chaque couvert pour chaque parcelle partie 2 ---
# ------------------------------------------------------------------------------

        try :
            req_sql = 'DROP TABLE IF EXISTS couvert_vegetal_surfzh_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE couvert_vegetal_surfzh_{} as
                   SELECT id, id_parcelle,couv_veget,sum(st_area(geometry)) as area,
                       st_multi(st_union(geometry)) as geometry
                   FROM couvert_vegetal_surfzh_p1_{} as a
                   GROUP BY id_parcelle,couv_veget
                       ;
                   """\
               .format(nom_base,nom_base)
            cur.execute(req_sql)

            req_sql = "SELECT RecoverGeometryColumn" \
                     "('couvert_vegetal_surfzh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')".format(nom_base)
            cur.execute(req_sql)

            req_sql = "SELECT RecoverGeometryColumn" \
                     "('couvert_vegetal_surfzh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')".format(nom_base)
            cur.execute(req_sql)

            req_sql = "SELECT CreateSpatialIndex('couvert_vegetal_surfzh_{}','GEOMETRY');".format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a22 = u"Calcul de la surface du couvert vegetal (partie 2) réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a22 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(44)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul de la surface du couvert vegetal (partie 2) : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ---- Calcul de la surface de chaque couvert pour chaque parcelle partie 3 ----
# ------------------------------------------------------------------------------

        try :
            req_sql = 'DROP TABLE IF EXISTS couvert_vegetal_tabc_surfzh_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE couvert_vegetal_tabc_surfzh_{} as
                   with one as (
                       SELECT id, id_parcelle,
                           CASE WHEN couv_veget = "Couvert haut"
                               THEN area
                               ELSE 0
                           END AS area_couvht,
                           CASE WHEN couv_veget like "%Couvert interm%"
                               THEN area
                               ELSE 0
                           END AS area_couvint,
                           CASE WHEN couv_veget like "Couvert bas"
                               THEN area
                               ELSE 0
                            END AS area_couvbs,
                           CASE WHEN couv_veget like "%Pas de couvert v%"
                               THEN area
                               ELSE 0
                           END AS area_nocouv,
                           st_multi(st_union(geometry)) as geometry
                       FROM couvert_vegetal_surfzh_{} as a
                       GROUP BY id_parcelle,couv_veget
                   )
                   SELECT one.id as id, one.id_parcelle as id_parcelle, sum(area_couvht) as area_couvht,
                       sum(area_couvint) as area_couvint, sum(area_couvbs) as area_couvbs,
                       sum(area_nocouv) as area_nocouv,
                       b.geom as geometry
                   FROM one, zh_parcelle_ppour_{} as b
                   WHERE one.id= b.id
                   GROUP BY one.id;
                   """\
               .format(nom_base,nom_base,nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('couvert_vegetal_tabc_surfzh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('couvert_vegetal_tabc_surfzh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('couvert_vegetal_tabc_surfzh_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a23 = u"Calcul de la surface du couvert vegetal (partie 3) réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a23 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(46)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul de la surface"
                         u" du couvert vegetal (partie 3) : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# -------------------------- Calcul de la rugosité -----------------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS couvert_vegetal_rug_surfzh_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE couvert_vegetal_rug_surfzh_{} as
                   SELECT id, id_parcelle, area_couvht, area_couvint, area_couvbs, area_nocouv,
                       (area_couvbs * 0.2333 + area_couvint * 0.4167 + area_couvht)
                           /(area_couvbs + area_couvint + area_couvht + area_nocouv) as rugosite,
                       geometry
                   FROM couvert_vegetal_tabc_surfzh_{} as a ;
                   """\
               .format(nom_base, nom_base)

            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('couvert_vegetal_rug_surfzh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('couvert_vegetal_rug_surfzh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('couvert_vegetal_rug_surfzh_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a24 = u"Calcul de la rugosité réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a24 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(48)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul de la rugosite : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# --------------- Calcul du centroide de chaque parcelle -----------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS zh_parcelle_ppour_pt_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE zh_parcelle_ppour_pt_{} as
                   SELECT id, id_parcelle,{},
                       min(st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOM)),
                       st_centroid(a.GEOM))) as distance,
                       CASE WHEN min(st_distance
                           (ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOM)), st_centroid(a.GEOM))
                           ) > 200
                           THEN 0
                           ELSE 1 - (min
                               (st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOM)),
                                st_centroid(a.GEOM))) * 0.005)
                       END AS prox_lit_min,
                   st_centroid(a.geom) as geometry
                   FROM zh_parcelle_ppour_{} as a, cours_eau_permanents_fusion_{} as b
                   GROUP BY id_parcelle;
                     """\
               .format(nom_base,liste_chp_zh, nom_base, nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_pt_{}', 'GEOMETRY', 2154, 'POINT', 'XYZ')
                       """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_pt_{}', 'GEOMETRY', 2154, 'POINT', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('zh_parcelle_ppour_pt_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a25 = u"Calcul du centroide de chaque parcelle réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a25 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(50)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul du centroide de chaque parcelle : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ----------------------- Reprojection du centroide ----------------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS zh_parcelle_ppour_pt2_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE zh_parcelle_ppour_pt2_{} as
                   SELECT id, id_parcelle,{},distance,prox_lit_min, b.ogc_fid as id_ceau,
                       ST_ClosestPoint(b.GEOMETRY, a.GEOMETRY) as geometry
                   FROM zh_parcelle_ppour_pt_{} as a, cours_eau_permanents_fusion_{} as b
                   WHERE st_distance(ST_ClosestPoint(b.GEOMETRY, a.GEOMETRY), a.GEOMETRY) = distance
                       and st_distance(ST_ClosestPoint(b.GEOMETRY, a.GEOMETRY), a.GEOMETRY) < 200
                   GROUP BY id_parcelle;
                   """\
               .format(nom_base,liste_chp_zh,nom_base,nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_pt2_{}', 'GEOMETRY', 2154, 'POINT', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_pt2_{}', 'GEOMETRY', 2154, 'POINT', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('zh_parcelle_ppour_pt2_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a26= u"Reprojection du centroide de chaque parcelle réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a26 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(60)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la reprojection du centroide de chaque parcelle : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ---------- Calcul du linéaire du cours d'eau dans un rayon de 1000m ----------
# --------------------- autour de la projection orthogonale --------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS meandre_ce_clip_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE meandre_ce_clip_{} as
                   SELECT id, id_parcelle,{},distance,prox_lit_min,
                   st_intersection(st_buffer(a.geometry,1000),b.geometry) as geometry
                   FROM zh_parcelle_ppour_pt2_{} as a, cours_eau_permanents_fusion_{} as b
                   WHERE st_intersects(st_buffer(a.geometry,100),b.geometry)
                   AND a.ROWID IN
                       (SELECT ROWID
                           FROM SpatialIndex WHERE f_table_name = {}
                           AND search_frame = b.geometry)
                    AND id_ceau = b.ogc_fid
                   ;
                   """\
                   .format(nom_base, liste_chp_zh, nom_base, nom_base, '"' + "zh_parcelle_ppour_pt2_" + nom_base + '"')
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('meandre_ce_clip_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('meandre_ce_clip_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('meandre_ce_clip_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a27 = u"Calcul du linéaire du cours d'eau dans un rayon de 1000m " \
                u"autour de la projection orthogonale réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a27 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(62)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul du linéaire du cours d'eau dans un rayon de 1000m "
                         u"autour de la projection orthogonale : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# --------------------- simplification des cours d'eau -------------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS cours_eau_permanents_fusion_s_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE cours_eau_permanents_fusion_s_{} as
                   SELECT ogc_fid,{},{},
                       st_multi(st_simplify(geometry,{})) as geometry
                   FROM cours_eau_permanents_fusion_{} as a;
                   """\
                   .format(nom_base, chp_reg, chp_nom, sim_ceau, nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('cours_eau_permanents_fusion_s_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('cours_eau_permanents_fusion_s_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XY')
                       """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('cours_eau_permanents_fusion_s_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            a28 = u"Simplification des cours d'eau réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a28 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(64)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la simplification des cours d'eau : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ------ Calcul du centroide de chaque parcelle sur cours d'eau simplifie ------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS zh_parcelle_ppour_pt_s_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE zh_parcelle_ppour_pt_s_{} as
                   SELECT id, id_parcelle,{},
                       min(st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOM)),
                           st_centroid(a.GEOM))) as distance,
                       CASE WHEN min
                               (st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOM)),
                               st_centroid(a.GEOM))) > 200
                           THEN 0
                           ELSE 1 - (min(st_distance(ST_ClosestPoint(b.GEOMETRY, st_centroid(a.GEOM)),
                               st_centroid(a.GEOM))) * 0.005)
                       END AS prox_lit_min,
                       st_centroid(a.geom) as geometry
                   FROM zh_parcelle_ppour_{} as a, cours_eau_permanents_fusion_s_{} as b
                   GROUP BY id_parcelle;
                     """\
                   .format(nom_base,liste_chp_zh, nom_base, nom_base)
            cur.execute(req_sql)
            conn.commit()

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_pt_s_{}', 'GEOMETRY', 2154, 'POINT', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_pt_s_{}', 'GEOMETRY', 2154, 'POINT', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            req_sql = """
                   SELECT CreateSpatialIndex('zh_parcelle_ppour_pt_s_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a29 = u"Calcul du centroide de chaque parcelle pour les cours d'eaux simplifiés réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a29 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(66)


        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul du centroide de chaque parcelle"
                         u" pour les cours d'eaux simplifiés : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ---------- Reprojection du centroide sur le cours d'eau simplifié ------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS zh_parcelle_ppour_pt2_s_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE zh_parcelle_ppour_pt2_s_{} as
                   SELECT id, id_parcelle,{},distance,prox_lit_min, b.ogc_fid as id_ceau,
                       ST_ClosestPoint(b.GEOMETRY, a.GEOMETRY) as geometry
                   FROM zh_parcelle_ppour_pt_s_{} as a, cours_eau_permanents_fusion_s_{} as b
                   WHERE st_distance(ST_ClosestPoint(b.GEOMETRY, a.GEOMETRY), a.GEOMETRY) = distance
                       AND st_distance(ST_ClosestPoint(b.GEOMETRY, a.GEOMETRY), a.GEOMETRY) < 200
                   GROUP BY b.ogc_fid,id_parcelle;
                     """\
                   .format(nom_base,liste_chp_zh, nom_base, nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_pt2_s_{}', 'GEOMETRY', 2154, 'POINT', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('zh_parcelle_ppour_pt2_s_{}', 'GEOMETRY', 2154, 'POINT', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('zh_parcelle_ppour_pt2_s_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a30 = u"Reprojection du centroide des parcelles sur le cours d'eau simplifié réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a30 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(68)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la reprojection du centroide des parcelles"
                         u" sur le cours d'eau simplifié : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# -------------------------- calcul du méandrage -------------------------------
# ------------------------------------------------------------------------------

        try:
            req_sql = 'DROP TABLE IF EXISTS meandre_ce_clip_s_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE meandre_ce_clip_s_{} as
                   SELECT id, id_parcelle,{},distance,prox_lit_min,id_ceau,
                       st_multi(st_intersection(st_buffer(a.geometry,1000),b.geometry)) as geometry
                   FROM zh_parcelle_ppour_pt2_s_{} as a, cours_eau_permanents_fusion_s_{} as b
                   WHERE st_intersects(st_buffer(a.geometry,100),b.geometry)
                       AND a.ROWID IN
                       (SELECT ROWID
                           FROM SpatialIndex WHERE f_table_name = {}
                           AND search_frame = b.geometry)
                           AND a.id_ceau = b.ogc_fid;
                     """\
                   .format(nom_base, liste_chp_zh, nom_base, nom_base, '"' + "zh_parcelle_ppour_pt2_s_" + nom_base + '"')
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('meandre_ce_clip_s_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('meandre_ce_clip_s_{}', 'GEOMETRY', 2154, 'MULTILINESTRING', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('meandre_ce_clip_s_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a31 = u"Calcul du méandrage réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a31 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(70)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul du méandrage : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# -------------------- Calcul de l'indice de sinuosité -------------------------
# (calcul de la difference de longueur entre cours d'eau et cours d'eau simplifié)
# ------------------------------------------------------------------------------
        try :
            req_sql = 'DROP TABLE IF EXISTS indice_sinuosite_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE indice_sinuosite_{} as
                   WITH one as (
                       SELECT a.id, a.id_parcelle,
                           st_length(a.geometry)-st_length(b.geometry) as difference,
                           CASE WHEN (st_length(a.geometry)/st_length(b.geometry))/2 > 1
                               THEN 1
                               ELSE (st_length(a.geometry)/st_length(b.geometry))/2
                           END AS ind_sin
                       FROM meandre_ce_clip_{} as a, meandre_ce_clip_s_{} as b
                       WHERE a.id = b.id
                   )
                   SELECT one.*, st_multi(c.geom) as geometry
                   FROM one, zh_parcelle_ppour_{} as c
                   WHERE one.id = c.id;
                   """\
               .format(nom_base, nom_base,nom_base,nom_base)
            cur.execute(req_sql)
            conn.commit()

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('indice_sinuosite_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('indice_sinuosite_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            req_sql = """
                   SELECT CreateSpatialIndex('indice_sinuosite_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a32 = u"Calcul de l'indice de sinuosité réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a32 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(72)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul de l'indice de sinuosité : contacter l'admin").exec_()
            return
            pass





# ------------------------------------------------------------------------------
# ---------------------- export shapefile du parcellaire -----------------------
# ------------------------------------------------------------------------------

        shp_zh_parcelle_ppour = dossier_temp + '/zh_parcelle_ppour_' + nom_base + '.shp'

        nom_ligne_com = 'ogr2ogr -f "ESRI Shapefile"  %s -lco ENCODING=UTF8 -spat_srs 2154 %s "%s" ' \
                       % (shp_zh_parcelle_ppour, path_base, 'zh_parcelle_ppour_' + nom_base)

        try:
            subprocess.run(nom_ligne_com, shell=True)

            a33 = u"Export au format shapefile du parcellaire réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a33 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de l'export au format shapefile "
                                            u"du parcellaire : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# --------------- Données d'entrée pour le calcul de la pente ------------------
# ------------------------------------------------------------------------------

        liste_rge = []
        for dossier, sous_dossiers, fichiers in os.walk(mnt):
            for fichier in fichiers:
                nom_table, extension = os.path.splitext(fichier)
                nom_table_lower = nom_table.lower()
                extension = extension.lower()
                if extension == ".asc"  :
                    path_rge = mnt + '/' + fichier
                    liste_rge.append(path_rge)

        output_vrt = dossier_temp + "/vrt.vrt"
        clip_shp = shp_zh_parcelle_ppour
        output_clip = dossier_temp + "/vrt_clip.vrt"
        output_pente = dossier_temp + "/pente.asc"
        output_penteshp = dossier_temp + "/pente.shp"


# # ------------------------------------------------------------------------------
# # ----------------- creation d'un vrt avec les MNT necessaires -----------------
# # ------------------------------------------------------------------------------

        print(liste_rge)
        try:
            vrt = processing.run('gdal:buildvirtualraster',
                                {'INPUT': liste_rge, 'RESOLUTION': 1, 'PROJ_DIFFERENCE': 'TRUE',
                                 'ASSIGN_CRS': 'EPSG:2154', 'SEPARATE': 'FALSE', 'OUTPUT': output_vrt})
            a34 = u"Création du VRT réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a34 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la création du VRT : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ------------------ découpage du VRT suivant les zones humides  ---------------
# ------------------------------------------------------------------------------

        try:
            clip = processing.run('gdal:cliprasterbymasklayer',{'INPUT': output_vrt, 'MASK': clip_shp,'ASSIGN_CRS': 'EPSG:2154','OUTPUT': output_clip})
            a35 = u"Découpage du VRT réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a35 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors de la découpage du VRT : contacter l'admin").exec_()
            return
            pass

# ------------------------------------------------------------------------------
# ---------------- calcul de la pente pour chaque zone humide ------------------
# ------------------------------------------------------------------------------

        try:
            slope = processing.run('gdal:slope', {'INPUT': output_clip, 'BAND': 1, 'SCALE': 1, 'AS_PERCENT': 'TRUE',
                                                 'ASSIGN_CRS': 'EPSG:2154', 'COMPUTE_EDGES': 'TRUE',
                                                 'OUTPUT': output_pente})

            a36 = u"Calcul de la pente pour chaque zone humide réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a36 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur du calcul de la pente pour chaque zone humide : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# ----------------- vectorisation des résultat du calcul de pente --------------
# ------------------------------------------------------------------------------
        try:
            shp = processing.run('grass7:r.to.vect',
                                {'column': 'pente', 'GRASS_OUTPUT_TYPE_PARAMETER': 3, 'input': output_pente,
                                 'output': output_penteshp, 'type': 2})

            a37 = u"Vectorisation du calcul de la pente pour chaque zone humide réussie !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a37 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur de la vectorisation du calcul de la pente "
                         u"pour chaque zone humide : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# --------- Import du shp des pentes dans la base de données -------------------
# ------------------------------------------------------------------------------

        nom_ligne_com = 'ogr2ogr -append {} {} -nln {} ' \
                       '-a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI ' \
                       '-lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry ' \
                       '-spat {} {} {} {}'.format(path_base, output_penteshp, "pente_" + nom_base, xmin, ymin, xmax,
                                                   ymax)

        try:
            subprocess.run(nom_ligne_com, shell=True)
            a38 = u"Import du shp des pentes dans la base de données réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a38 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(74)

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors de l'import du shp des pentes dans la base de données : contacter l'admin").exec_()
            return
            pass


# ------------------------------------------------------------------------------
# -------------- Calcul de la pente moyenne pour chaque parcelle ---------------
# ------------------------------------------------------------------------------

        try:
            req_sql = """
                    SELECT max(avg)
                    FROM (
                       SELECT avg(pente) as avg
                       FROM zh_parcelle_ppour_{} as a, pente_{} as b
                       WHERE st_intersects(a.geom,b.geometry)
                       GROUP BY id_parcelle
                    );
                    """\
                    .format(nom_base,nom_base,nom_base)
            cur.execute(req_sql)
            conn.commit()

            resultat = cur.fetchall()
            for max in resultat :
               avg_max = (max[0])

        except BaseException as erreur:
            boite.message(self, str(erreur), u"Erreur lors du calcul de la pente moyenne : contacter l'admin").exec_()
            return
            pass

        try:
            req_sql = 'DROP TABLE IF EXISTS pente_moy_{}'.format(nom_base)
            cur.execute(req_sql)
            req_sql = """
                   CREATE TABLE pente_moy_{} as
                   SELECT id, id_parcelle,{},
                       avg(pente) as pente_moy,
                       CASE WHEN avg(pente) = 1
                           THEN 0
                           ELSE 1-log(1+avg(pente)/{})
                       END AS indi_pente,
                       a.geom as geometry
                   FROM zh_parcelle_ppour_{} as a, pente_{} as b
                   WHERE st_intersects(a.geom,b.geometry)
                       AND a.ROWID IN
                       (SELECT ROWID
                           FROM SpatialIndex WHERE f_table_name = {}
                           AND search_frame = b.geometry)
                   GROUP BY id;
                   """\
               .format(nom_base,liste_chp_zh,avg_max,nom_base,nom_base, '"' + "zh_parcelle_ppour_" + nom_base + '"')
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('pente_moy_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT RecoverGeometryColumn
                       ('pente_moy_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                   """\
                   .format(nom_base)
            cur.execute(req_sql)

            req_sql = """
                   SELECT CreateSpatialIndex('pente_moy_{}','GEOMETRY');
                   """\
                   .format(nom_base)
            cur.execute(req_sql)
            conn.commit()

            a39 = u"Calcul de l'indice de pente moyenne réussi !!"
            t = "time elapsed: {:.2f}s".format(time.time() - start_time)
            details = ''
            details += "\n" + a39 + " (" + t + ")"
            self.detailsPlainTextEdit_2.appendPlainText(details)
            self.progressBar.setValue(76)

        except BaseException as erreur:
            boite.message(self, str(erreur),
                         u"Erreur lors du calcul de l'indice de pente moyenne : contacter l'admin").exec_()
            return
            pass

#         #### suppression des 2 dossiers temporaires ###
#         shutil.rmtree(dossier_temp)




        if not self.checkBox_2.isChecked():

# ------------------------------------------------------------------------------
# -------------------- Import du shp des données lidar -------------------------
# ------------------------------------------------------------------------------

            nom_ligne_com = 'ogr2ogr -append {} {} -nln {}   ' \
                          '-a_srs EPSG:2154 -gt unlimited -nlt PROMOTE_TO_MULTI -lco SPATIAL_INDEX=YES -lco GEOMETRY_NAME=geometry' \
                          ' -spat {} {} {} {}'.format(path_base, lidar, "lidar_"+nom_base, xmin, ymin, xmax, ymax)
            try:
                subprocess.run(nom_ligne_com, shell=True)
                a40 = u"Import du Lidar réussi !!"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a40 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(78)

            except BaseException as erreur:
                boite.message(self, str(erreur),
                             u"Erreur lors de l'import du Lidar : contacter l'admin").exec_()
                return
                pass

    # ------------------------------------------------------------------------------
    # ------------ Calcul du buffer de 20m autour des points Lidar -----------------
    # ------------------------------------------------------------------------------

            try:
                req_sql = 'DROP TABLE IF EXISTS buffer_20m_{}'.format(nom_base)
                cur.execute(req_sql)
                req_sql = """
                       CREATE TABLE buffer_20m_{} as
                       SELECT id, id_parcelle,{},
                           st_multi(st_buffer(geometry,20)) as geometry
                       FROM zh_parcelle_ppour_pt2_{};
                       """\
                  .format(nom_base, liste_chp_zh,nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT RecoverGeometryColumn
                           ('buffer_20m_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                       """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT RecoverGeometryColumn
                           ('buffer_20m_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                       """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT CreateSpatialIndex('buffer_20m_{}','GEOMETRY');
                       """\
                       .format(nom_base)
                cur.execute(req_sql)
                conn.commit()

                a41 = u"Calcul du buffer de 20m autour des points Lidar réussi !!"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a41 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(80)


            except BaseException as erreur:
                boite.message(self, str(erreur),
                             u"Erreur lors du calcul du buffer de 20m autour des points Lidar : contacter l'admin").exec_()
                return
                pass

    # ------------------------------------------------------------------------------
    # --------------- Selection des points du LIDAR à conserver --------------------
    # ------------------------------------------------------------------------------

            try:
                req_sql = 'DROP TABLE IF EXISTS lidar_buffer_20m_{}'.format(nom_base)
                cur.execute(req_sql)
                req_sql = """
                       CREATE TABLE lidar_buffer_20m_{} as
                       SELECT id, id_parcelle,{},
                           b.*
                       FROM buffer_20m_{} as a, lidar_{} as b
                       WHERE st_intersects(a.geometry,b.geometry)
                        AND a.ROWID IN
                           (SELECT ROWID
                               FROM SpatialIndex WHERE f_table_name = {}
                               AND search_frame = b.geometry);
              """\
                  .format(nom_base,liste_chp_zh, nom_base,nom_base,'"' + "buffer_20m_" + nom_base + '"')
                cur.execute(req_sql)

                req_sql = """
                       SELECT RecoverGeometryColumn
                           ('lidar_buffer_20m_{}', 'GEOMETRY', 2154, 'MULTIPOINT', 'XYZ')
                           """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT RecoverGeometryColumn
                           ('lidar_buffer_20m_{}', 'GEOMETRY', 2154, 'MULTIPOINT', 'XY')
                           """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT CreateSpatialIndex('lidar_buffer_20m_{}','GEOMETRY');
                       """\
                       .format(nom_base)
                cur.execute(req_sql)
                conn.commit()

                a42 = u"Selection du Lidar dans les buffer de 20m autour des reprojections réussie !!"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a42 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(82)


            except BaseException as erreur:
                boite.message(self, str(erreur),
                             u"Erreur lors de la selection du Lidar dans les buffer de 20m "
                             u"autour des reprojections : contacter l'admin").exec_()
                return
                pass


    # ------------------------------------------------------------------------------
    # --------------------- Calcul de la hauteur de berge --------------------------
    # ------------------------------------------------------------------------------

            try:
                req_sql = 'DROP TABLE IF EXISTS hauteur_berge_{}'.format(nom_base)
                cur.execute(req_sql)
                req_sql = """
                       CREATE TABLE hauteur_berge_{} as
                       SELECT a.id as id, a.id_parcelle as id_parcelle,
                           max(altitude) - min(altitude) as ht_berge, b.geometry as geometry
                       FROM lidar_buffer_20m_{} as a
                           LEFT OUTER JOIN buffer_20m_{} as b
                           ON a.id = b.id
                       GROUP BY a.id;
                       """\
                   .format(nom_base,nom_base,nom_base)
                cur.execute(req_sql)

                req_sql = """
                      SELECT RecoverGeometryColumn
                      ('hauteur_berge_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                      """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                      SELECT RecoverGeometryColumn
                      ('hauteur_berge_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                      """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                      SELECT CreateSpatialIndex('hauteur_berge_{}','GEOMETRY');
                      """\
                       .format(nom_base)
                cur.execute(req_sql)
                conn.commit()

                a43 = u"Calcul de la hauteur de berge réussi !!"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a43 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(84)


            except BaseException as erreur:
                boite.message(self, str(erreur),
                             u"Erreur lors du calcul de la hauteur de berge : contacter l'admin").exec_()
                return
                pass

    # ------------------------------------------------------------------------------
    # -------------------- Calcul de l'indice d'incision ---------------------------
    # ------------------------------------------------------------------------------

            try:
                req_sql = 'DROP TABLE IF EXISTS indice_incision_{}'.format(nom_base)
                cur.execute(req_sql)
                req_sql = """
                       CREATE TABLE indice_incision_{} as
                       SELECT id, id_parcelle,
                           CASE WHEN ht_berge < 0.2 THEN 1
                               WHEN ht_berge >=0.2 AND ht_berge <0.5 THEN 0.82
                               WHEN ht_berge >=0.5 AND ht_berge <1 THEN 0.64
                               WHEN ht_berge >=1 AND ht_berge <1.5 THEN 0.46
                               WHEN ht_berge >=1.5 AND ht_berge <=2 THEN 0.28
                               ELSE 0.1
                           END AS incision,
                           geometry
                       FROM hauteur_berge_{};
                       """\
                   .format(nom_base,nom_base)
                cur.execute(req_sql)

                req_sql = """
                      SELECT RecoverGeometryColumn
                      ('indice_incision_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                      """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                      SELECT RecoverGeometryColumn
                      ('indice_incision_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                      """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                      SELECT CreateSpatialIndex('indice_incision_{}','GEOMETRY');
                      """\
                       .format(nom_base)
                cur.execute(req_sql)
                conn.commit()

                a44 = u"Calcul de l'indice d'incision réussi !!"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a44 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(86)

            except BaseException as erreur:
                boite.message(self, str(erreur),
                             u"Erreur lors du calcul de l'indice d'incision : contacter l'admin").exec_()
                return
                pass

    # ------------------------------------------------------------------------------
    # ----------------- Création de la table finale des indicateurs ----------------
    # ------------------------------------------------------------------------------

            try:
                req_sql = 'DROP TABLE IF EXISTS indicateur_zh_{}'.format(nom_base)
                cur.execute(req_sql)
                req_sql = """
                       CREATE TABLE indicateur_zh_{} as
                       WITH site as (SELECT id, id_parcelle, {}, geom as geometry FROM zh_parcelle_ppour_{}),
                       sinuosite as (SELECT id, id_parcelle, ind_sin FROM indice_sinuosite_{}),
                       pente as (SELECT id, id_parcelle, indi_pente FROM pente_moy_{}),
                       incision as (SELECT id, id_parcelle, incision FROM indice_incision_{}),
                       fosse as (SELECT id, id_parcelle, rarete_fosse FROM rarete_fosse_{}),
                       rugosite as (SELECT id, id_parcelle, rugosite FROM couvert_vegetal_rug_surfzh_{}),
                       distance as (SELECT id, id_parcelle, prox_lit_min FROM zh_parcelle_ppour_pt_{})
                       SELECT site.id, site.id_parcelle, {},
                           CASE WHEN ind_sin IS NULL THEN 0 ELSE ind_sin END AS ind_sin,
                           indi_pente,
                           CASE WHEN incision IS NULL THEN 0 ELSE incision END AS incision,
                           CASE WHEN rarete_fosse IS NULL THEN 1 ELSE rarete_fosse END AS rarete_fosse,
                           rugosite,prox_lit_min,geometry
                       FROM site
                           LEFT OUTER JOIN sinuosite ON site.id = sinuosite.id
                           LEFT OUTER JOIN pente ON site.id = pente.id
                           LEFT OUTER JOIN incision ON site.id = incision.id
                           LEFT OUTER JOIN fosse ON site.id = fosse.id
                           LEFT OUTER JOIN rugosite ON site.id = rugosite.id
                           LEFT OUTER JOIN distance ON site.id = distance.id;
                       """\
                          .format(nom_base,liste_chp_zh,nom_base,nom_base,nom_base,
                                  nom_base,nom_base,nom_base,nom_base,liste_chp_zh)
                print (req_sql)
                cur.execute(req_sql)


                req_sql = """
                       SELECT RecoverGeometryColumn
                           ('indicateur_zh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                       """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT RecoverGeometryColumn
                           ('indicateur_zh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                       """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT CreateSpatialIndex('indicateur_zh_{}','GEOMETRY');
                       """\
                       .format(nom_base)
                cur.execute(req_sql)

                a45 = u"Creation de la table finale des indicateurs réussie !!"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a45 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(100)

            except BaseException as erreur:
                boite.message(self, str(erreur),
                             u"Erreur lors de la creation de la table finale des indicateurs : contacter l'admin").exec_()
                return
                pass     


    # ------------------------------------------------------------------------------
    # ----------------- Création de la table finale des indicateurs ----------------
    # ------------------------------------------------------------------------------

        if self.checkBox_2.isChecked():
			
            try:
                req_sql = 'DROP TABLE IF EXISTS indicateur_zh_{}'.format(nom_base)
                cur.execute(req_sql)
                req_sql = """
                       CREATE TABLE indicateur_zh_{} as
                       WITH site as (SELECT id, id_parcelle, {}, geom as geometry FROM zh_parcelle_ppour_{}),
                       sinuosite as (SELECT id, id_parcelle, ind_sin FROM indice_sinuosite_{}),
                       pente as (SELECT id, id_parcelle, indi_pente FROM pente_moy_{}),
                       fosse as (SELECT id, id_parcelle, rarete_fosse FROM rarete_fosse_{}),
                       rugosite as (SELECT id, id_parcelle, rugosite FROM couvert_vegetal_rug_surfzh_{}),
                       distance as (SELECT id, id_parcelle, prox_lit_min FROM zh_parcelle_ppour_pt_{})
                       SELECT site.id, site.id_parcelle, {},
                           CASE WHEN ind_sin IS NULL THEN 0 ELSE ind_sin END AS ind_sin,
                           indi_pente,
                           CASE WHEN rarete_fosse IS NULL THEN 1 ELSE rarete_fosse END AS rarete_fosse,
                           rugosite,prox_lit_min,geometry
                       FROM site
                           LEFT OUTER JOIN sinuosite ON site.id = sinuosite.id
                           LEFT OUTER JOIN pente ON site.id = pente.id
                           LEFT OUTER JOIN fosse ON site.id = fosse.id
                           LEFT OUTER JOIN rugosite ON site.id = rugosite.id
                           LEFT OUTER JOIN distance ON site.id = distance.id;
                       """\
                          .format(nom_base,liste_chp_zh,nom_base,nom_base,nom_base,
                                  nom_base,nom_base,nom_base,liste_chp_zh)
                print (req_sql)
                cur.execute(req_sql)


                req_sql = """
                       SELECT RecoverGeometryColumn
                           ('indicateur_zh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XYZ')
                       """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT RecoverGeometryColumn
                           ('indicateur_zh_{}', 'GEOMETRY', 2154, 'MULTIPOLYGON', 'XY')
                       """\
                       .format(nom_base)
                cur.execute(req_sql)

                req_sql = """
                       SELECT CreateSpatialIndex('indicateur_zh_{}','GEOMETRY');
                       """\
                       .format(nom_base)
                cur.execute(req_sql)

                a45 = u"Creation de la table finale des indicateurs réussie !!"
                t = "time elapsed: {:.2f}s".format(time.time() - start_time)
                details = ''
                details += "\n" + a45 + " (" + t + ")"
                self.detailsPlainTextEdit_2.appendPlainText(details)
                self.progressBar.setValue(100)

            except BaseException as erreur:
                boite.message(self, str(erreur),
                             u"Erreur lors de la creation de la table finale des indicateurs : contacter l'admin").exec_()
                return
                pass

################### FIN DU PROCESSUS ###################
        conn.commit()
        conn.close()

        msg4 = QMessageBox()
        msg4.setIcon(QMessageBox.Information)
        msg4.setText(u"L'export des données dans la base .sqlite est fini !!")
        msg4.setInformativeText(u"Vous pouvez utiliser la base !!")
        msg4.setWindowTitle(u"Avertissement")
        msg4.exec_()