# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IZHuRRPI
                                 A QGIS plugin
 Identification des Zones Humides Ralentissant les Ruisselements et Prévenant
 Inondations
                              -------------------
        begin                : 2019-09-01
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5 import QtCore
from PyQt5.QtGui import QIcon, QPixmap
from PyQt5.QtWidgets import QDialog, QMessageBox

import os.path


from .gc_utils import (load_ui)
from .Izhurrpi_dialog import Ui_IzhurrpiDialogBase
from .couches import rechercherunecouche
from .questions import afficherquestions
from .creationbase import creerbase
from .internet import ouvririnternet
from .gestionerreurs import gerererreur
from .boite import boite


pluginPath = os.path.dirname(__file__)
FORM_CLASS = load_ui('Izhurrpi_dialog_base')


class appelfonction(QDialog,QPixmap, FORM_CLASS, rechercherunecouche,afficherquestions,creerbase,ouvririnternet, gerererreur):

    def __init__(self, iface, parent=None):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.iface = iface



        self.tabWidget.setStyleSheet( " QTabBar:tab {color: #464749; background-color: #E6E7E8;} "
                                      "QTabBar:tab:selected {color: #EE7F00 ;background-color: white} QTabBar:tab:hover {color: #EE7F00 ;background-color: white}"
                                      "QPushButton {color : #EE7F00 ; background-color : white;  "
                                      "border-style: solid; border-width: 2px; border-color: #EE7F00 ; font: bold 10px;min-width: 4em; padding: 2.5px;}"
                                      "QPushButton:hover {color : white; background-color : #EE7F00 ;}"
                                      "QToolButton {color : #EE7F00 ; background-color : white; "
                                                "border-style: solid; border-width: 1px; border-color: #EE7F00 ; font: bold 9px;min-width: 1em; padding: 1px;}"
                                               "QToolButton:hover {color : white; background-color : #EE7F00 ;}"
                                      "QTabWidget {background-color: white;border-color: white}"
                                      "QLabel {color : #464749;}"
                                      "QTextBrowser {color : #464749;}"
                                      "QListWidget:item {color : #464749;}"
                                      "QListWidget:item:hover {color : #464749;background-color:  #FDC99B;}"
                                      "QListWidget:item:selected {color : #FDC99B;background-color: white;}"
                                      "QDoubleSpinBox:up-button:hover {background-color : #EE7F00 ;}"
                                      "QDoubleSpinBox:down-button:hover {background-color : #EE7F00 ;}"
                                      "QDoubleSpinBox{colors : #464749; border-style: solid; border-width: 1px; border-color: #464749 ;min-width: 5em; padding: 2px;}"
                                      )



####### affichage des icones des partenaires #######
        #### Cerema ####
        self.pushButton.setStyleSheet("qproperty-icon: url(:/plugins/Izhurrpi/icones/Cerema.png)")
        self.pushButton.setIconSize(QtCore.QSize(150, 50))

        #### SMABB ####
        self.pushButton_2.setStyleSheet("qproperty-icon: url(:/plugins/Izhurrpi/icones/SMABB.png)")
        self.pushButton_2.setIconSize(QtCore.QSize(100, 100))

####### parametres de la photo de la page d accueil de l extension  #######
        path_photo = os.path.join(os.path.dirname(__file__), 'icones', 'Couverture.png')
        self.label.setPixmap(QPixmap (path_photo))

####### affichage et lien vers le guide et le manuel d utilisation #######

        #### lien vers le manuel d utilisation
        path_manuel = os.path.join(os.path.dirname(__file__), 'doc', 'Manuel_Utilisation_Izhurrpi.pdf')
        path_manuel = path_manuel.replace('\\', '/')

        #### affichage du guide et du manuel d utilisation ####
        guide = u"<a href=""http://zones-humides.org/guide-de-la-m%C3%A9thode-nationale-d%C3%A9valuation-des-fonctions-des-zones-humides"">le guide </a>" + u"de la méthode nationale d'évaluation des fonctions des zones humides"
        aide= "<br /> <br />"u"<a href=path_manuel>l'aide </a>" + u"pour l'utilisation de l'outil IZHuRRPI"
        aide = aide.replace("path_manuel", path_manuel)
        guide += aide
        self.label_guide.setText(guide)
        self.label_guide.setOpenExternalLinks(True)


####### Ouvrir les sites a partir des icones #######

        self.pushButton.clicked.connect(self.ouvrir_ceremaweb)
        self.pushButton_2.clicked.connect(self.ouvrir_smabbweb)


####### Creer base #######
        boite.boite_verte_simple(self.doubleSpinBox_parce, self.label_parce)
        boite.boite_verte_simple(self.doubleSpinBox_pc_zh, self.label_pc_zh)
        #boite.boite_verte_simple(self.doubleSpinBox_surf_zh, self.label_surf_zh)
        boite.boite_verte_simple(self.doubleSpinBox_sim_ceau, self.label_sim_ceau)

        #### selection des dossiers et fichiers ####
        self.toolButton_base.clicked.connect(self.select_dossier_base)
        self.toolButton_zh.clicked.connect(self.select_dossier_zh)
        self.toolButton_ze.clicked.connect(self.select_ze)
        self.toolButton_ceau.clicked.connect(self.select_ceau)
        self.toolButton_ocs.clicked.connect(self.select_ocs)
        self.toolButton_mnt.clicked.connect(self.select_dossier_mnt)
        self.toolButton_lidar.clicked.connect(self.select_lidar)


        #### creation de la base ####
        self.pushButton_save_base.clicked.connect(self.create_base)

        #### verification des erreurs ####
        self.lineEdit_base.textChanged.connect(self.gerer_erreur)
        self.lineEdit_nom_base.textChanged.connect(self.gerer_erreur)
        self.lineEdit_zh.textChanged.connect(self.gerer_erreur)
        self.lineEdit_ze.textChanged.connect(self.gerer_erreur)
        self.lineEdit_ceau.textChanged.connect(self.gerer_erreur)
        self.lineEdit_ocs.textChanged.connect(self.gerer_erreur)
        self.lineEdit_mnt.textChanged.connect(self.gerer_erreur)
        self.checkBox.stateChanged.connect(self.gerer_erreur)
        self.lineEdit_lidar.textChanged.connect(self.gerer_erreur)


        #### mise a zero de la barre de progression ####
        self.progressBar.setMinimum(0)
        self.progressBar.setMaximum(100)
        self.progressBar.setValue(0)


####### Afficher les questions #######

        #### selection des dosssier et fichiers ####
        self.toolButton_base_2.clicked.connect(self.select_dossier_base_2)

        #### affichage des questions ####
        self.pushButton_questions.clicked.connect(self.affiche_questions)

        #### verification des erreurs ####
        self.lineEdit_base_2.textChanged.connect(self.gerer_erreur)
        self.lineEdit_preserv.textChanged.connect(self.gerer_erreur)
        self.lineEdit_restaur.textChanged.connect(self.gerer_erreur)




###Rechercher et afficher les couches

        #### selection des dosssier et fichiers ####
        self.toolButton_base_4.clicked.connect(self.select_dossier_base_4)

        #### recherche des couches ####
        self.pushButton_nom.clicked.connect(self.recherche_couche_theme)

        #### chargement des couches dans QGIS ####
        self.addSelectedPushButton.clicked.connect(self.affiche_couche)

        #### verification des erreurs ####
        self.lineEdit_base_4.textChanged.connect(self.gerer_erreur)



