# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IZHuRRPI
                                 A QGIS plugin
 Identification des Zones Humides Ralentissant les Ruisselements et Prévenant
 Inondations
                              -------------------
        begin                : 2019-09-01
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import sqlite3

from .boite import boite


class afficherquestions():

    def select_dossier_base_2(self):
        base_2,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier .sqlite de la base souhaitée", '*.sqlite')
        self.lineEdit_base_2.setText(base_2)

    def affiche_questions(self):

        #### definition des variables ####
        dossier_base_2 = self.lineEdit_base_2.text()
        nom_base = (dossier_base_2.split('/')[-1]).split('.')[0]

        formule_preserv = self.lineEdit_preserv.text()
        formule_restaur = self.lineEdit_restaur.text()

        #### Verification du remplissage des champs #######

        if dossier_base_2 == '':
            boite.boite_rouge(self.toolButton_base_2, self.lineEdit_base_2, self.label_base_2)
            boite.message(self,u"Vous n'avez pas renseigné d'analyse",u"Remplisser le champ avant de relancer").exec_()
            return

        if formule_preserv == '':
            boite.boite_rouge_simple(self.lineEdit_preserv, self.label_preserv)
            boite.message(self, u"Aucune formule pour la note de préservation",
                          u"Taper une formule avant de relancer").exec_()
            return

        if formule_restaur == '':
            boite.boite_rouge_simple(self.lineEdit_restaur, self.label_restaur)
            boite.message(self, u"Aucune formule pour la note de restauration",
                          u"Taper une formule avant de relancer").exec_()
            return



        #### connexion a la base selectionnee ####

        conn = sqlite3.dbapi2.connect(dossier_base_2)
        cur = conn.cursor()
        conn.enable_load_extension(True)
        conn.execute("SELECT load_extension('mod_spatialite')")

        #### creation de la table des resulats ####

        ### note de préservation
        try :
            req_sql = """ALTER TABLE indicateur_zh_{} ADD  nt_preserv real;"""\
                .format(nom_base,nom_base)
            print (req_sql)
            cur.execute(req_sql)

            try:
                req_sql = """UPDATE indicateur_zh_{}
                             SET nt_preserv = {};""".format(nom_base, formule_preserv)
                print (req_sql)
                cur.execute(req_sql)
                req_sql = """SELECT UpdateLayerStatistics(\'indicateur_zh_{}\');""".format(nom_base)
                cur.execute(req_sql)
                boite.message(self, u"Calcul de la note de préservation réussie",
                              u"Continuez pour calculer la note de restauration").exec_()

            except BaseException as erreur:
                boite.message(self, str(erreur),
                              u"Erreur lors du calcul de la note de préservation :"
                              u"\n - vérifier la présence de l'indice d'incision "
                              u"\n - ou contacter l'admin").exec_()
                return


        except BaseException as erreur:
            msg4 = QMessageBox.question(self,u"Attention",
                                        u"Une note de préservation est déjà calculée !! \n" 
                                        u"Voulez-vous  en calculer une nouvelle !!",QMessageBox.Yes | QMessageBox.No)

            if msg4 == QMessageBox.Yes  :
                try:
                    req_sql = """UPDATE indicateur_zh_{}
                                 SET nt_preserv = {};""".format(nom_base, formule_preserv)
                    print (req_sql)
                    cur.execute(req_sql)
                    req_sql = """SELECT UpdateLayerStatistics(\'indicateur_zh_{}\');""".format(nom_base)
                    cur.execute(req_sql)
                    boite.message(self, u"Calcul de la note de préservation réussie",
                                  u"Continuez pour calculer la note de restauration").exec_()

                except BaseException as erreur:
                    boite.message(self, str(erreur),
                                  u"Erreur lors du calcul de la note de préservation :"
                                  u"\n - vérifier la présence de l'indice d'incision "
                                  u"\n - ou contacter l'admin").exec_()
                    return
            else :
                pass


        ### note de restauration
        try :
            req_sql = """ALTER TABLE indicateur_zh_{} ADD  nt_restaur real;"""\
                .format(nom_base,nom_base)
            print (req_sql)
            cur.execute(req_sql)

            try:
                req_sql = """UPDATE indicateur_zh_{}
                             SET nt_restaur = {};""".format(nom_base, formule_restaur)
                print (req_sql)
                cur.execute(req_sql)
                req_sql = """SELECT UpdateLayerStatistics(\'indicateur_zh_{}\');""".format(nom_base)
                cur.execute(req_sql)

                boite.message(self, u"Calcul de la note de restauration réussie",
                              u"La table indicateur_zh_" + nom_base + u" a été mise à jour").exec_()

            except BaseException as erreur:
                boite.message(self, str(erreur),
                              u"Erreur lors du calcul de la note de restauration :"
                              u"\n - vérifier la présence de l'indice d'incision "
                              u"\n - ou contacter l'admin").exec_()
                return

        except BaseException as erreur:
            msg4 = QMessageBox.question(self,u"Attention",
                                        u"Une note de rstauration est déjà calculée !! \n" 
                                        u"Voulez-vous  en calculer une nouvelle !!",QMessageBox.Yes | QMessageBox.No)

            if msg4 == QMessageBox.Yes:

                try:
                    req_sql = """UPDATE indicateur_zh_{}
                                 SET nt_restaur = {};""".format(nom_base, formule_restaur)
                    print (req_sql)
                    cur.execute(req_sql)
                    req_sql = """SELECT UpdateLayerStatistics(\'indicateur_zh_{}\');""".format(nom_base)
                    cur.execute(req_sql)
                    boite.message(self, u"Calcul de la note de restauration réussie",
                              u"La table indicateur_zh_" + nom_base + u" a été mise à jour").exec_()

                except BaseException as erreur:
                    boite.message(self, str(erreur),
                                  u"Erreur lors du calcul de la note de restauration :"
                                  u"\n - vérifier la présence de l'indice d'incision "
                                  u"\n - ou contacter l'admin").exec_()
                    return
            else :
                pass




        conn.commit()
        conn.close()
