# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IZHuRRPI
                                 A QGIS plugin
 Identification des Zones Humides Ralentissant les Ruisselements et Prévenant
 Inondations
                              -------------------
        begin                : 2019-09-01
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import sqlite3, os

from .boite import boite


class rechercherunecouche():
    def select_dossier_base_4(self):
        base_4,_ = QFileDialog.getOpenFileName(self, u"sélectionner le fichier .sqlite de la base souhaitée",'*.sqlite')
        self.lineEdit_base_4.setText(base_4)


    def _get_cur(self):

        #### definition de la connection ####
        dossier_base_4 = self.lineEdit_base_4.text()

        conn = sqlite3.dbapi2.connect(dossier_base_4)
        cur = conn.cursor()
        conn.enable_load_extension(True)
        conn.execute("SELECT load_extension('mod_spatialite')")
        return cur, conn, dossier_base_4

    def recherche_couche_theme(self):

        self.resultsListWidget.clear()

        #### recuperation des parametres de connexion ####

        cur, conn, dossier_base_4 = self._get_cur()

        #### Verification du remplissage des champs ####

        if dossier_base_4 == '':
            boite.boite_rouge(self.toolButton_base_4, self.lineEdit_base_4, self.label_base_4)
            boite.message(self,u"Vous n'avez pas renseigné d'analyse",u"Remplisser le champ avant de relancer").exec_()
            return

        #### listage des tables contenues dans la base selectionnee ####

        req_sql = "SELECT name FROM sqlite_master WHERE type='table' and" \
                  " name not like '%idx%' and name not like '%GEOMETRY%' and name not like '%patial%'" \
                  " and name not like '%sql%' and name not like '%Elementary%'" \
                  " ORDER BY name;"
        cur.execute(req_sql)
        tables = cur.fetchall()

        for table in tables:
            t = table[0]

            ### affichage des couches dans la fenetre ###
            self.resultsListWidget.addItem(t)

        conn.commit()
        conn.close()


    def affiche_couche(self):

        ### recuperation des parametres de connexion
        cur, conn, dossier_base_4 = self._get_cur()
        nom_base, extension = os.path.splitext(dossier_base_4)
        nom_base = (nom_base.lower()).split('/')[-1]
        #### recuperation des couches affichees dans la fenetre
        for i in range(self.resultsListWidget.count()):
            # Loop through and add selected items
            ### recuperation du nom de la ou des couches selectionnees ###
            if self.resultsListWidget.item(i).isSelected():
                # Add the layer
                layer = self.resultsListWidget.item(i).text()

                ### affichage de la couche meandre_ce_clip_gemapi_test7 qui n a pas de geometrie ###
                if layer == "meandre_ce_clip_" + nom_base :
                        couche = layer
                        uri = QgsDataSourceUri()
                        uri.setDatabase(dossier_base_4)
                        schema = ''
                        table = couche
                        geom_column = None
                        uri.setDataSource(schema, table, geom_column)
                        vlayer = QgsVectorLayer(uri.uri(), table, "spatialite")
                        QgsProject.instance().addMapLayer(vlayer)

                ### affichage de la couche n_parcelle_bdp_gemapi_test7 qui n a pas de geometrie ###
                elif layer == "n_parcelle_bdp_" + nom_base :
                        couche = layer
                        uri = QgsDataSourceUri()
                        uri.setDatabase(dossier_base_4)
                        schema = ''
                        table = couche
                        geom_column = None
                        uri.setDataSource(schema, table, geom_column)
                        vlayer = QgsVectorLayer(uri.uri(), table, "spatialite")
                        QgsProject.instance().addMapLayer(vlayer)

                ### affichage des autres couche geometriques ###
                else :
                    req_sql = "SELECT f_table_name, f_geometry_column FROM geometry_columns where f_table_name = '{}';".format(layer)
                    cur.execute(req_sql)
                    tables = cur.fetchall()
                    for table in tables:
                        couche = table[0]
                        geometrie_name = table[1]

                    ### verification de l existence de donnees dans les couches ###
                    req_sql = "SELECT * from %s ;" %(couche)
                    cur.execute(req_sql)
                    tables = cur.fetchall()

                    ### si la couche est vide, ne pas la charger dans QGIS ###
                    if tables == [] :
                        boite.message(self, u"La couche " + couche + u" est vide", u"Elle ne va pas s'ouvrir").exec_()

                    ### si la couche n'est pas vide, elle se charge dans QGIS ###
                    else:
                        try :
                            if  geometrie_name == 'geometry' :
                                geom_column = 'geometry'
                            else :
                                geom_column = 'geom'

                            uri = QgsDataSourceUri()
                            uri.setDatabase(dossier_base_4)
                            schema = ''
                            table = couche
                            geom_column = geom_column
                            uri.setDataSource(schema, table, geom_column)
                            vlayer = QgsVectorLayer(uri.uri(), table, "spatialite")
                            QgsProject.instance().addMapLayer(vlayer)

                        except BaseException as erreur:
                            erreur = erreur
                            boite.message(self, u"Erreur lors du chargement de la couche dans QGIS : contacter l'admin", "").exec_()
                            pass

        conn.commit()
        conn.close()
