# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IZHuRRPI
                                 A QGIS plugin
 Identification des Zones Humides Ralentissant les Ruisselements et Prévenant
 Inondations
                              -------------------
        begin                : 2019-09-01
        git sha              : $Format:%H$
        copyright            : (C) 2017 by Antoine Lemot
        email                : antoine.lemot@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtWidgets import QFileDialog, QMessageBox
from qgis.core import *

import re, os.path, unicodedata

from .boite import boite


class gerererreur(boite) :

    def gerer_erreur(self,checked):

        envoyeur = self.sender()  # recuperer le widget emettant le signal

        lien = envoyeur.text()
        lien = unicode(lien)
        lien = unicodedata.normalize('NFKD', lien).encode('ascii', 'ignore')

        nom_rectifie = envoyeur.text()
        nom_rectifie = nom_rectifie.replace(' ', '_')
        nom_rectifie = nom_rectifie.lower()
        nom_rectifie = nom_rectifie.encode('utf8', 'replace')
        nom_rectifie = nom_rectifie.decode('utf8', 'replace')
        nom_rectifie = unicodedata.normalize('NFD', nom_rectifie).encode('ascii', 'ignore')
        nom_rectifie = nom_rectifie.decode('utf8', 'replace')

################### controle de la fenetre Rechercher une couche ###################
        ####### controle du chemin de la base #######
        boite.controle_chemin(self,'lineEdit_base_4',self.toolButton_base_4,self.lineEdit_base_4,self.label_base_4)



################### controle de la fenetre Afficher les questions ###################
        ####### controle du chemin de la base #######
        boite.controle_chemin(self,'lineEdit_base_2',self.toolButton_base_2,self.lineEdit_base_2,self.label_base_2)



################### controle de la fenetre Creer une base  ###################

        ####### controle du chemin de la base #######
        boite.controle_chemin(self,'lineEdit_base',self.toolButton_base,self.lineEdit_base,self.label_base)

        ####### controle du nom de la base #######

        if envoyeur.objectName() == 'lineEdit_nom_base':
            if envoyeur.text() != "":
                self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #B3C21A}')
                self.label_nom_base.setStyleSheet('QLabel {color: #B3C21A}')

                #### Verification du nom de la base : espace remplace par _, caracteres speciaux supprimes, majuscules supprimees ####
                self.lineEdit_nom_base.setText(nom_rectifie)

                #### Verification du nom de la base : ne doit pas commencer par un chiffre ####
                try :
                    var = int(nom_rectifie[0])
                    self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
                    self.label_nom_base.setStyleSheet('QLabel {color:#FF0000}')
                    boite.message(self,u"Le nom de la base ne doit pas commencer par un chiffre",u"Renommer l'analyse avant de relancer").exec_()
                    self.lineEdit_nom_base.clear()
                except  :
                    return

            if envoyeur.text() == "":
                self.lineEdit_nom_base.setStyleSheet('QLineEdit {border: 2px solid #FF0000}')
                self.label_nom_base.setStyleSheet('QLabel {color :#FF0000}')


        ####### controle de la zone humide #######
        boite.controle_chemin(self,'lineEdit_zh',self.toolButton_zh,self.lineEdit_zh,self.label_zh)

        if envoyeur.objectName() == 'lineEdit_zh':
            if envoyeur.text() != "":

                #### Verification de l exitence d un chiffre en premiere posistion ###
                premier_carcactere = os.path.basename(envoyeur.text())[0]
                if re.findall('\d+', premier_carcactere) != []:
                    boite.boite_rouge(self.toolButton_zh, self.lineEdit_zh, self.label_zh)
                    boite.message(self,u"Le nom de la zone humide commence par un chiffre",u"Modifier le nom avant de relancer").exec_()
                    self.lineEdit_zh.clear()
                    return

        ####### controle de la zone d'etude #######

        boite.controle_chemin(self, 'lineEdit_ze', self.toolButton_ze, self.lineEdit_ze, self.label_ze)

        if envoyeur.objectName() == 'lineEdit_ze':
            if envoyeur.text() != "":

                #### Verification de l exitence d un chiffre en premiere posistion ###
                premier_carcactere = os.path.basename(envoyeur.text())[0]
                if re.findall('\d+', premier_carcactere) != []:
                    boite.boite_rouge(self.toolButton_ze, self.lineEdit_ze, self.label_ze)
                    boite.message(self,u"Le nom de la zone d'étude commence par un chiffre",u"Modifier le nom avant de relancer").exec_()
                    self.lineEdit_ze.clear()
                    return


        ####### controle des cours d eau #######

        boite.controle_chemin(self, 'lineEdit_ceau', self.toolButton_ceau, self.lineEdit_ceau, self.label_ceau)

        if envoyeur.objectName() == 'lineEdit_ceau':
            if envoyeur.text() != "":

                #### Verification de l exitence d un chiffre en premiere posistion ###
                premier_carcactere = os.path.basename(envoyeur.text())[0]
                if re.findall('\d+', premier_carcactere) != []:
                    boite.boite_rouge(self.toolButton_ceau, self.lineEdit_ceau, self.label_ceau)
                    boite.message(self,u"Le nom des cours d'eau commence par un chiffre",u"Modifier le nom avant de relancer").exec_()
                    self.lineEdit_ceau.clear()
                    return

                nom_table, extension = os.path.splitext(envoyeur.text())
                fichier_cpg =  nom_table + ".cpg"
                fichier_cpg2 = nom_table + ".CPG"
                if os.path.isfile(fichier_cpg) or os.path.isfile(fichier_cpg2) :
                    with open(fichier_cpg, "r") as fichier:
                        fichier_entier = fichier.read()
                        files = fichier_entier.split("\n")
                        if 'UTF-8' in files:
                            if self.checkBox.isChecked():
                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                boite.message(self, u"Le shp des cours d'eau semble être encodée en UTF8",
                                                  u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                return
                            else:
                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                return
                        else :
                            if self.checkBox.isChecked():
                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                            else :
                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                              u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                return

                    with open(fichier_cpg2, "r") as fichier :
                        fichier_entier = fichier.read()
                        files = fichier_entier.split("\n")
                        if 'UTF-8' in files:
                            if self.checkBox.isChecked():
                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                boite.message(self, u"Le shp des cours d'eau semble être encodée en UTF8",
                                              u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                return
                            else:
                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                                return
                        else :
                            if self.checkBox.isChecked():
                                self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                            else :
                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                              u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                return
                else :
                    if self.checkBox.isChecked():
                        self.checkBox.setStyleSheet('QCheckBox {color: #a5d50c}')
                        return
                    else :
                        self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                        boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                                                      u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                        return


        ####### Verification du choix de l encodage (case a cocher) #######

        if envoyeur.objectName() == 'checkBox':

            #### UTF-8, case cochee ####

            if checked :

                lineEdit_ceau = self.lineEdit_ceau.text()
                if lineEdit_ceau != "":
                        nom_table, extension = os.path.splitext(lineEdit_ceau)
                        fichier_cpg = nom_table + ".cpg"
                        fichier_cpg2 = nom_table + ".CPG"
                        if os.path.isfile(fichier_cpg) or os.path.isfile(fichier_cpg2) :

                            with open(fichier_cpg, "r") as fichier:
                                fichier_entier = fichier.read()
                                files = fichier_entier.split("\n")
                                if 'UTF-8' in files:
                                    self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                    boite.message(self, u"Le shp des cours d'eau semble être encodée en UTF8",
                                                          u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                    return
                                else:
                                    self.checkBox.setStyleSheet('QCheckBox {color: #B3C21A}')

                            with open(fichier_cpg2, "r") as fichier :
                                fichier_entier = fichier.read()
                                files = fichier_entier.split("\n")
                                if 'UTF-8' in files:
                                    self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                    boite.message(self, u"Le shp des cours d'eau semble être encodée en UTF8",
                                                      u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                    return
                                else :
                                    self.checkBox.setStyleSheet('QCheckBox {color: #B3C21A}')
                                    return
                        else :

                            self.checkBox.setStyleSheet('QCheckBox {color: #B3C21A}')



             #### ISO-8859-1, case non cochee ####

            else :
                lineEdit_ceau = self.lineEdit_ceau.text()
                if lineEdit_ceau != "":
                    nom_table, extension = os.path.splitext(lineEdit_ceau)
                    fichier_cpg = nom_table + ".cpg"
                    fichier_cpg2 = nom_table + ".CPG"
                    if os.path.isfile(fichier_cpg) or os.path.isfile(fichier_cpg2):

                        with open(fichier_cpg, "r") as fichier:
                            fichier_entier = fichier.read()
                            files = fichier_entier.split("\n")
                            if 'UTF-8' in files:
                                self.checkBox.setStyleSheet('QCheckBox {color: #B3C21A}')
                                return
                            else:
                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                              u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()


                        with open(fichier_cpg2, "r") as fichier:
                            fichier_entier = fichier.read()
                            files = fichier_entier.split("\n")
                            if 'UTF-8' in files:
                                self.checkBox.setStyleSheet('QCheckBox {color: #B3C21A}')
                                return
                            else:
                                self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                                boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                              u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                                return
                    else:
                        self.checkBox.setStyleSheet('QCheckBox {color: #FF0000}')
                        boite.message(self, u'La BD TOPO® choisie semble être encodée en ISO-88591',
                                                  u"Vérifier la version et/ou l'encodage puis décocher la case si besoin").exec_()
                        return


        ####### controle du l'occupation du sol #######

        boite.controle_chemin(self, 'lineEdit_ocs', self.toolButton_ocs, self.lineEdit_ocs, self.label_ocs)
        if envoyeur.objectName() == 'lineEdit_ocs':
            if envoyeur.text() != "":

                #### Verification de l exitence d un chiffre en premiere posistion ###
                premier_carcactere = os.path.basename(envoyeur.text())[0]
                if re.findall('\d+', premier_carcactere) != []:
                    boite.boite_rouge(self.toolButton_ocs, self.lineEdit_ocs, self.label_ocs)
                    boite.message(self,u"Le nom du shp de l'occupation du sol commence par un chiffre",u"Modifier le nom avant de relancer").exec_()
                    self.lineEdit_ocs.clear()
                    return

                ####### Verification de la structure de la table d'occupation du sol #######
                chemin_shp =  envoyeur.text()
                chemin_shp2 = envoyeur.text()
                layer = QgsVectorLayer(chemin_shp, "ogr")
                layer_dataProvider = layer.dataProvider()
                layer_attrib_names = layer_dataProvider.fields()
                attributeList = layer_attrib_names.toList()
                liste_attribut = []

                for attribute in attributeList:
                    liste_attribut.append(attribute.name())
                    if "Classe" not in liste_attribut :
                        boite.boite_rouge(self.toolButton_ocs, self.lineEdit_ocs, self.label_ocs)
                        boite.message(self, u"Le shp de l'occupation du sol ne contient pas de colonne 'Classe' ",
                                      u"Assurez-vous d'utliser une occupation du sol compatible").exec_()
                        self.lineEdit_ocs.clear()
                        return

        ####### controle du dossier de MNT #######

        boite.controle_chemin(self, 'lineEdit_mnt', self.toolButton_mnt, self.lineEdit_mnt, self.label_mnt)


        ####### controle du Lidar #######

        boite.controle_chemin(self, 'lineEdit_lidar', self.toolButton_lidar, self.lineEdit_lidar, self.label_lidar)

        if envoyeur.objectName() == 'lineEdit_lidar':
            if envoyeur.text() != "":

                #### Verification de l exitence d un chiffre en premiere posistion ###
                premier_carcactere = os.path.basename(envoyeur.text())[0]
                if re.findall('\d+', premier_carcactere) != []:
                    boite.boite_rouge(self.toolButton_lidar, self.lineEdit_lidar, self.label_lidar)
                    boite.message(self,u"Le nom du shp de l'occupation du sol commence par un chiffre",u"Modifier le nom avant de relancer").exec_()
                    self.lineEdit_lidar.clear()
                    return

        ####### controle de la formule de la note de préservation #######

        if envoyeur.objectName() == 'lineEdit_preserv':
            if envoyeur.text() != "":
              boite.boite_verte_simple(self.lineEdit_preserv, self.label_preserv)
            else :
                boite.boite_rouge_simple(self.lineEdit_preserv, self.label_preserv)
                boite.message(self, u"Aucune formule pour la note de préservation",
                                  u"Taper une formule avant de relancer").exec_()
                return

        ####### controle de la formule de la note de restauration #######

        if envoyeur.objectName() == 'lineEdit_restaur':
            if envoyeur.text() != "":
              boite.boite_verte_simple(self.lineEdit_restaur, self.label_restaur)
            else :
                boite.boite_rouge_simple(self.lineEdit_restaur, self.label_restaur)
                boite.message(self, u"Aucune formule pour la note de restauration",
                                  u"Taper une formule avant de relancer").exec_()
                return
